% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube.R
\name{NewCube}
\alias{NewCube}
\title{Cross-derivatives via automatic differentiation}
\usage{
NewCube(x, j, dim = 2)
}
\arguments{
\item{x}{(scalar) value at which the function is evaluated.}

\item{j}{optional input. See \sQuote{Details}.}

\item{dim}{dimension \eqn{d} of the input vector, defaults to two.}
}
\value{
\code{NewCube} returns an object of \code{\link{class}} \sQuote{ADCube} according to its inputs. See \sQuote{Details}.
}
\description{
Basic building blocks for evaluating functionals \eqn{f:R^d \to R}{f:R^d -> R} and all their cross-derivatives at a given point \eqn{x \in R^d}{x in R^d}.
}
\details{
If the optional argument \code{j} is specfied, then the function \eqn{f(x)=x_j} and all its cross-derivatives (all of which but one will be zero, the derivative with respect to the \eqn{j}th component being 1) are evaluated with \eqn{x_j} being set to the value of \code{x}.

If the optional argument \code{j} is not used, then the function \eqn{f(x) =c} and all its cross-derivatives (all of which will be zero) are evaluated with \eqn{c} beting set to the value of \code{x}.

From these primitive function evaluations, more complicated functions can be constructed using the operations documented in \code{\link{CrossSum}}.
}
\references{
Griewank, A., Lehmann, L., Leovey, H. and Zilberman, M. (2014). Automatic evaluations of cross-derivatives, \emph{Mathematics of Computation} \strong{83}(285): 251-274.
}
\seealso{
\code{\link{CrossSum}}
}
\author{
Berwin A. Turlach <berwin.turlach@gmail.com>
}
\keyword{internal}
