% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run}
\alias{run}
\title{Runs \code{SimBIID_model} object}
\usage{
run(model, pars, tstart, tstop, u, tspan, nrep = 1, parallel = FALSE,
  mc.cores = NA)
}
\arguments{
\item{model}{An object of class \code{SimBIID_model}.}

\item{pars}{A named vector of parameters.}

\item{tstart}{The time at which to start the simulation.}

\item{tstop}{The time at which to stop the simulation.}

\item{u}{A named vector of initial states.}

\item{tspan}{A numeric vector containing the times at which to 
save the states of the system.}

\item{nrep}{Specifies the number of simulations to run.}

\item{parallel}{A \code{logical} determining whether to use parallel processing or not.}

\item{mc.cores}{Number of cores to use if using parallel processing.}
}
\value{
An object of class \code{SimBIID_run}, essentially a list 
        containing elements:
        \itemize{
            \item{sums:}{ a \code{data.frame()} with summaries of the model runs. This
            includes columns \code{run}, \code{completed}, \code{t}, \code{u*} 
            (see help file for \code{SimBIID_model} for more details);}
            \item{runs:}{ a \code{data.frame()} object, containing columns: \code{run},
            \code{t}, \code{u*} (see help file for \code{SimBIID_model} for more details).
            These contain time series counts for the simulations. Note that this will
            only be returned if \code{tspan = TRUE} in the original \code{SimBIID_model} object.}
            \item{bootEnd:}{ a time point denoting when bootstrapped estimates end and predictions
            begin (for \code{predict.PMCMC()} method). }
        }
}
\description{
Wrapper function that compiles (if necessary) and runs
             a \code{SimBIID_model} object. Returns results in a 
             user-friendly manner as a \code{SimBIID_run} object, 
             for which \code{print()} and \code{plot()} generics 
             are provided.
}
\examples{
\donttest{
## set up SIR simulation model
transitions <- c(
    "S -> beta * S * I -> I", 
    "I -> gamma * I -> R"
)
compartments <- c("S", "I", "R")
pars <- c("beta", "gamma")
model <- mparseRcpp(
    transitions = transitions, 
    compartments = compartments,
    pars = pars
)

## compile and run model
sims <- run(
    model = model,
    pars = c(beta = 0.001, gamma = 0.1),
    tstart = 0,
    tstop = 100,
    u = c(S = 119, I = 1, R = 0)
)
sims

## add tspan option to return
## time series counts at different
## time points
model <- mparseRcpp(
    transitions = transitions, 
    compartments = compartments,
    pars = pars,
    tspan = TRUE
)
sims <- run(
    model = model,
    pars = c(beta = 0.001, gamma = 0.1),
    tstart = 0,
    tstop = 100,
    u = c(S = 119, I = 1, R = 0),
    tspan = seq(1, 100, length.out = 10)
)
sims

## run 100 replicate simulations and
## plot outputs
sims <- run(
    model = model,
    pars = c(beta = 0.001, gamma = 0.1),
    tstart = 0,
    tstop = 100,
    u = c(S = 119, I = 1, R = 0),
    tspan = seq(1, 100, length.out = 10),
    nrep = 100
)
sims
plot(sims)
}
}
\seealso{
\code{\link{mparseRcpp}}, \code{\link{print.SimBIID_runs}}, \code{\link{plot.SimBIID_runs}}
}
