% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragments.R
\name{ValidateCells}
\alias{ValidateCells}
\title{Validate cells present in fragment file}
\usage{
ValidateCells(
  object,
  cells = NULL,
  tolerance = 0.5,
  max.lines = 5e+07,
  verbose = TRUE
)
}
\arguments{
\item{object}{A \code{\link{Fragment}} object}

\item{cells}{A character vector containing cell barcodes to search for.
If NULL, use the cells stored in the Fragment object.}

\item{tolerance}{Fraction of input cells that can be unseen before returning
TRUE. For example, \code{tolerance = 0.01} will return TRUE when 99% of cells
have observed fragments in the file. This can be useful if there are cells
present that have much fewer total counts, and would require extensive
searching before a fragment from those cells are found.}

\item{max.lines}{Maximum number of lines to read in without finding the
required number of cells before returning FALSE. Setting this value avoids
having to search the whole file if it becomes clear that the expected cells
are not present. Setting this value to NULL will enable an exhaustive search
of the entire file.}

\item{verbose}{Display messages}
}
\description{
Search for a fragment from each cell that should exist in the fragment file.
Will iterate through chunks of the fragment file until at least one fragment
from each cell barcode requested is found.
}
\concept{fragments}
