% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iranges-methods.R
\name{inter-range-methods}
\alias{inter-range-methods}
\alias{range}
\alias{range,ChromatinAssay-method}
\alias{range,Seurat-method}
\alias{reduce,ChromatinAssay-method}
\alias{reduce}
\alias{reduce,Seurat-method}
\alias{gaps,ChromatinAssay-method}
\alias{gaps}
\alias{gaps,Seurat-method}
\alias{disjoin,ChromatinAssay-method}
\alias{disjoin}
\alias{disjoin,Seurat-method}
\alias{isDisjoint,ChromatinAssay-method}
\alias{isDisjoint}
\alias{isDisjoint,Seurat-method}
\alias{disjointBins,ChromatinAssay-method}
\alias{disjointBins}
\alias{disjointBins,Seurat-method}
\title{Inter-range transformations for ChromatinAssay objects}
\usage{
\S4method{range}{ChromatinAssay}(x, ..., with.revmap = FALSE, na.rm = FALSE)

\S4method{range}{Seurat}(x, ..., with.revmap = FALSE, na.rm = FALSE)

\S4method{reduce}{ChromatinAssay}(x, drop.empty.ranges = FALSE, ...)

\S4method{reduce}{Seurat}(x, drop.empty.ranges = FALSE, ...)

\S4method{gaps}{ChromatinAssay}(x, start = NA, end = NA)

\S4method{gaps}{Seurat}(x, start = NA, end = NA)

\S4method{disjoin}{ChromatinAssay}(x, ...)

\S4method{disjoin}{Seurat}(x, ...)

\S4method{isDisjoint}{ChromatinAssay}(x, ...)

\S4method{isDisjoint}{Seurat}(x, ...)

\S4method{disjointBins}{ChromatinAssay}(x, ...)

\S4method{disjointBins}{Seurat}(x, ...)
}
\arguments{
\item{x}{A \code{\link{ChromatinAssay}} object}

\item{...}{Additional arguments}

\item{with.revmap}{See \code{\link[IRanges]{inter-range-methods}} in the
\pkg{IRanges} packages}

\item{na.rm}{Ignored}

\item{drop.empty.ranges}{See \code{?\link{IRanges}{inter-range-methods}}}

\item{start, end}{See \code{?\link{IRanges}{inter-range-methods}}}
}
\description{
The \code{range, reduce, gaps, disjoin, isDisjoint, disjointBins} methods
are available for \code{\link{ChromatinAssay}} objects.
}
\section{Functions}{
\itemize{
\item \code{range(Seurat)}: method for Seurat objects

\item \code{reduce(ChromatinAssay)}: method for ChromatinAssay objects

\item \code{reduce(Seurat)}: method for Seurat objects

\item \code{gaps(ChromatinAssay)}: method for ChromatinAssay objects

\item \code{gaps(Seurat)}: method for Seurat objects

\item \code{disjoin(ChromatinAssay)}: method for ChromatinAssay objects

\item \code{disjoin(Seurat)}: method for Seurat objects

\item \code{isDisjoint(ChromatinAssay)}: method for ChromatinAssay objects

\item \code{isDisjoint(Seurat)}: method for Seurat objects

\item \code{disjointBins(ChromatinAssay)}: method for ChromatinAssay objects

\item \code{disjointBins(Seurat)}: method for Seurat objects

}}
\seealso{
\itemize{
  \item{\link[IRanges]{inter-range-methods} in the \pkg{IRanges} package.}
  \item{\link[GenomicRanges]{inter-range-methods} in the \pkg{GenomicRanges}
  package}
  \item{\link{ChromatinAssay-class}}
 }
}
\concept{inter_range}
