% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{SetMotifData}
\alias{SetMotifData}
\alias{SetMotifData.Motif}
\alias{SetMotifData.Assay}
\alias{SetMotifData.Seurat}
\title{Set motif data}
\usage{
SetMotifData(object, ...)

\method{SetMotifData}{Motif}(object, slot, new.data, ...)

\method{SetMotifData}{Assay}(object, slot, new.data, ...)

\method{SetMotifData}{Seurat}(object, assay = NULL, ...)
}
\arguments{
\item{object}{A Seurat object}

\item{...}{Arguments passed to other methods}

\item{slot}{Name of slot to use}

\item{new.data}{motif matrix to add. Should be matrix or sparse matrix class}

\item{assay}{Name of assay whose data should be set}
}
\value{
Returns a \code{\link[Seurat]{Seurat}} object
}
\description{
Set motif matrix for given assay
}
\examples{
motif.obj <- GetMotifObject(object = atac_small)
SetMotifData(object = motif.obj, slot = 'data', new.data = matrix())
SetMotifData(object = atac_small[['peaks']], slot = 'data', new.data = matrix())
motif.matrix <- GetMotifData(object = atac_small)
SetMotifData(object = atac_small, assay = 'peaks', slot = 'data', new.data = motif.matrix)
}
