% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.bdh.taxa.R
\name{sim.bdh.taxa.gsa}
\alias{sim.bdh.taxa.gsa}
\title{Simulate a Phylogenetic Network to a Specified Number of Taxa}
\usage{
sim.bdh.taxa.gsa(
  m,
  n,
  numbsim,
  lambda,
  mu,
  nu,
  hybprops,
  hyb.inher.fxn,
  frac = 1,
  mrca = FALSE,
  complete = TRUE,
  stochsampling = FALSE,
  hyb.rate.fxn = NULL,
  trait.model = NULL
)
}
\arguments{
\item{m}{The number of taxa to simulate under the SSA}

\item{n}{The number of taxa.}

\item{numbsim}{Number of networks to simulate.}

\item{lambda}{Speciation rate.}

\item{mu}{Extinction rate.}

\item{nu}{Hybridization rate.}

\item{hybprops}{Vector that represents the proportion of Hybridizations that are lineage generative, lineage degenerative, and lineage neutral respectively.}

\item{hyb.inher.fxn}{A function for drawing the hybrid inheritance probabilities.}

\item{frac}{Sampling fraction: The proportion of extant tips included in the phylogeny (incomplete sampling).}

\item{mrca}{If \code{mrca=FALSE}: age is the time since origin. If \code{mrca=TRUE}: age is the time since most recent common ancestor of the extant tips.}

\item{complete}{If complete = TRUE, the tree with the extinct lineages is returned. If complete = FALSE, the extinct lineages are suppressed.}

\item{stochsampling}{When \code{stochsampling=TRUE}: Each extant tip is included into the final tree with probability frac.}

\item{hyb.rate.fxn}{The probability of a successful hybridization as a function of genetic distance between taxa. The default value of `NULL`` assumes that hybridization success is independent of genetic distance between taxa.}

\item{trait.model}{A list that dictates how a trait affects the hybridization process. The default value of \code{NULL} doesn't take a trait into account for simulation. See Details for more information.}
}
\value{
out Returns a list of numbsim networks with the time since origin / most recent common ancestor being 'age.' If tree goes extinct or no tips are sampled, return value is '0'. If only one extant and no extinct tips are sampled, return value is '1'. Each network has an additional attribute "inheritance" that represents the inheritance probabilities on the edges in the "reticulation" attribute.
}
\description{
Simulates a Phylogenetic Network under a birth-death-hybridization model. Simulates to a specified number of extant tips under the General Sampling Approach.
}
\details{
\code{hyb.inher.fxn} should return values between 0 and 1 and shouldn't require any arguments. E.g. \link{make.beta.draw} and \link{make.uniform.draw} create functions that fit these specifications

\code{hyb.rate.fxn} should take one argument for the genetic distance. The function should be defined on the range \eqn{[0,Inf)} and return values between \eqn{[0,1]}

\code{trait.model} is a list with the following named elements:
\itemize{
\item{\code{initial}}{ The initial trait state on the phylogeny}
\item{\code{hyb.event.fxn}}{ A function that denotes the trait of a hybrid child after a hybridization event. The function should have the arguments \code{parent_states} and \code{inheritance}. \code{parent_states} is vector with the ploidy states of the hybrid parents while \code{inheritance} is the inheritance probability of the first lineage denoted in \code{parent_states}.}
\item{\code{hyb.compatibility.fxn}}{ A function that describes when hybridization events can occur between two taxa based on their traits. The function should have the argument \code{parent_states}, a vector with the trait states of the two parents to the hybrid child. The function should return \code{TRUE} for when a hybridization event is allowed to proceed and \code{FALSE} otherwise.}
\item{\code{time.fxn}}{ A function that describes how traits change over time. The function should have the arguments \code{trait_states} and \code{timestep} in that order. \code{trait_states} is a vector containing the ploidy of all taxa while \code{timestep} is the amount of time given for trait evolution. The function should return a vector with the updated ploidy states of all taxa.}
\item{\code{spec.fxn}}{ A function that describes how the trait changes at speciation events.The function should have the argument \code{tip_state} which has the state of the lineage just before speciation. The function should return a vector with two values, one denoting the trait of each of the two new species after the event.}
}
}
\examples{
set.seed(17) ##smallest Quartan prime as seed
##Generate a tree with extinct leaves
net<-sim.bdh.taxa.gsa(m=21,n=5,1,3,2,0.5,c(1/3,1/3,1/3),
hyb.inher.fxn = make.uniform.draw(),complete=TRUE)[[1]]
}
