% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDIFLogistic.R
\name{plotDIFLogistic}
\alias{plotDIFLogistic}
\title{Function for characteristic curve of 2PL logistic DIF model}
\usage{
plotDIFLogistic(data, group, type = "both", item, item.name,
IRT = F, p.adjust.method = "none", purify = F, match = "score",
group.names = c("Reference", "Focal"))
}
\arguments{
\item{data}{numeric: the data matrix. See Details.}

\item{group}{numeric: the vector of group membership. See Details.}

\item{type}{character: a character string specifying which DIF effects must be tested.
Possible values are "both" (default), "udif" and "nudif". See Details.}

\item{item}{numeric: number of item to be plotted}

\item{item.name}{character: the name of item.}

\item{IRT}{logical: if IRT parameterization (\code{TRUE}, default) or classic logistic
parameterization (\code{FALSE}) may be applied.}

\item{p.adjust.method}{character:  the acronym of the method for p-value adjustment for
multiple comparisons. See Details.}

\item{purify}{logical: if item purification may be applied.}

\item{match}{specifies the type of matching criterion. Can be either \code{"score"} (default)
to compute the test score, or any continuous or discrete variable with the same length as the number
of rows of \code{Data}.}

\item{group.names}{character: names of reference and focal group.}
}
\description{
Plots characteristic curve of 2PL logistic DIF model
}
\details{
This function plots characteristic curve of 2PL logistic DIF model.
}
\examples{
\dontrun{
# loading libraries
library(difNLR, difR)

 # loading data based on GMAT
data(GMAT, package = "difNLR")
data  <- GMAT[, 1:20]
group <- GMAT[, 21]

# Characteristic curve by logistic regression model
plotDIFLogistic(data, group, item = 1)

# Characteristic curve by logistic regression model using scaled score
plotDIFLogistic(data, group, item = 1, IRT = T)

# Renaming reference and focal group
plotDIFLogistic(data, group, item = 1, group.names = c("Group 1", "Group 2"))
}


}
\author{
Adela Hladka \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
hladka@cs.cas.cz \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}
