% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShapeRotator.R
\name{plot_rotation_3D}
\alias{plot_rotation_3D}
\title{plot_rotation_3D}
\usage{
plot_rotation_3D(joined.data, data.1, data.2, specimen.num)
}
\arguments{
\item{joined.data}{an object of the class "array" that contains the joined
rotated arrays (data.1three-dimensional landmarks for structure #1 (e.g.
skull). It can either be the original dataset, the translated array, or the
rotated array}

\item{data.1}{an object of the class "array" that contains three-dimensional
landmarks for structure #1 (e.g. skull). It can either be the original
dataset, the translated array, or the rotated array}

\item{data.2}{an object of the class "array" that contains three-dimensional
landmarks for structure #2 (e.g. mandible). It can either be the original
dataset, the translated array, or the rotated array}

\item{specimen.num}{an integer object that indicates which specimen will be
plotted. The number of the specimen to be plotted corresponds to the
position in the "joined.data" array}
}
\value{
This function returns a 3D plot of the rotated structures (e.g. mandible
  and skull).
}
\description{
Plots the two rotated datasets in 3D
}
\details{
Plots the two rotated datasets in 3D for a specimen (specimen.num),
and each structure is plotted with a different colour.
Default is black and red. This uses the function scatter3D from the R package
plot3D (https://cran.r-project.org/web/packages/plot3D/) internally.
}
\examples{
\donttest{
rotation_45 = double.rotation(data.1, data.2, land.a, land.b, land.c, land.d,
land.e, land.f, land.g, land.h, 45)

rotation_45_t <- join.arrays(rotation_45$rotated1,
translate(rotation_45$rotated2, land.e , skull_translate))

plot_rotation_3D(rotation_45_t, data.1, data.2, specimen.num = 1)
}

}
\references{
M. Vidal-García, L. Bandara and J.S. Keogh. 2018. ShapeRotator:
An R tool for standardized rigid rotations of articulated three-dimensional
structures with application for geometric morphometrics.
Ecology and Evolution. DOI: 10.1002/ece3.4018
}
\author{
Marta Vidal-Garcia
}
