% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/preprocessing.R,
%   R/preprocessing5.R
\name{SCTransform}
\alias{SCTransform}
\alias{SCTransform.default}
\alias{SCTransform.Assay}
\alias{SCTransform.Seurat}
\alias{SCTransform.IterableMatrix}
\title{Perform sctransform-based normalization}
\usage{
SCTransform(object, ...)

\method{SCTransform}{default}(
  object,
  cell.attr,
  reference.SCT.model = NULL,
  do.correct.umi = TRUE,
  ncells = 5000,
  residual.features = NULL,
  variable.features.n = 3000,
  variable.features.rv.th = 1.3,
  vars.to.regress = NULL,
  latent.data = NULL,
  do.scale = FALSE,
  do.center = TRUE,
  clip.range = c(-sqrt(x = ncol(x = umi)/30), sqrt(x = ncol(x = umi)/30)),
  vst.flavor = "v2",
  conserve.memory = FALSE,
  return.only.var.genes = TRUE,
  seed.use = 1448145,
  verbose = TRUE,
  ...
)

\method{SCTransform}{Assay}(
  object,
  cell.attr,
  reference.SCT.model = NULL,
  do.correct.umi = TRUE,
  ncells = 5000,
  residual.features = NULL,
  variable.features.n = 3000,
  variable.features.rv.th = 1.3,
  vars.to.regress = NULL,
  latent.data = NULL,
  do.scale = FALSE,
  do.center = TRUE,
  clip.range = c(-sqrt(x = ncol(x = object)/30), sqrt(x = ncol(x = object)/30)),
  vst.flavor = "v2",
  conserve.memory = FALSE,
  return.only.var.genes = TRUE,
  seed.use = 1448145,
  verbose = TRUE,
  ...
)

\method{SCTransform}{Seurat}(
  object,
  assay = "RNA",
  new.assay.name = "SCT",
  reference.SCT.model = NULL,
  do.correct.umi = TRUE,
  ncells = 5000,
  residual.features = NULL,
  variable.features.n = 3000,
  variable.features.rv.th = 1.3,
  vars.to.regress = NULL,
  do.scale = FALSE,
  do.center = TRUE,
  clip.range = c(-sqrt(x = ncol(x = object[[assay]])/30), sqrt(x = ncol(x =
    object[[assay]])/30)),
  vst.flavor = "v2",
  conserve.memory = FALSE,
  return.only.var.genes = TRUE,
  seed.use = 1448145,
  verbose = TRUE,
  ...
)

\method{SCTransform}{IterableMatrix}(
  object,
  cell.attr,
  reference.SCT.model = NULL,
  do.correct.umi = TRUE,
  ncells = 5000,
  residual.features = NULL,
  variable.features.n = 3000,
  variable.features.rv.th = 1.3,
  vars.to.regress = NULL,
  latent.data = NULL,
  do.scale = FALSE,
  do.center = TRUE,
  clip.range = c(-sqrt(x = ncol(x = object)/30), sqrt(x = ncol(x = object)/30)),
  vst.flavor = "v2",
  conserve.memory = FALSE,
  return.only.var.genes = TRUE,
  seed.use = 1448145,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat object or UMI count matrix.}

\item{...}{Additional arguments passed to \code{sctransform::vst}.}

\item{cell.attr}{Optional metadata frame (cells × attributes).}

\item{reference.SCT.model}{Pre‐fitted SCT model (supports only \code{log_umi}
as latent variable). If provided, computes residuals via that model. When
\code{residual.features} is NULL, uses the model’s top
\code{variable.features.n}; otherwise, sets the assay’s variable features
to \code{residual.features}.}

\item{do.correct.umi}{Logical; if TRUE (default), stores corrected UMIs in
\code{counts}.}

\item{ncells}{Integer; number of cells to subsample when fitting NB
regression (default: 5000).}

\item{residual.features}{Character vector of genes to compute residuals for.
Default NULL (all genes). If set, these become the assay’s variable
features.}

\item{variable.features.n}{Integer; when \code{residual.features} is NULL,
select this many top features by residual variance (default: 3000).}

\item{variable.features.rv.th}{Numeric; if \code{variable.features.n} is NULL,
select features exceeding this residual‐variance threshold (default: 1.3).}

\item{vars.to.regress}{Character vector of metadata columns (e.g.
\code{percent.mito}) to regress out in a second, non‐regularized model.}

\item{latent.data}{Numeric matrix (cells × latent covariates) to regress out.}

\item{do.scale}{Logical; if TRUE, scale residuals to unit variance
(default: FALSE).}

\item{do.center}{Logical; if TRUE, center residuals to mean zero
(default: TRUE).}

\item{clip.range}{Numeric vector of length 2; range to clip residuals
(default \code{c(-sqrt(n/30), sqrt(n/30))}, with n = number of cells).}

\item{vst.flavor}{Character; if \code{"v2"}, uses \code{method = "glmGamPoi_offset"},
\code{n_cells = 2000}, and \code{exclude_poisson = TRUE} to fit \eqn{\theta} and
intercept only.}

\item{conserve.memory}{Logical; if TRUE, never builds the full residual
matrix (slower but memory‐efficient; forces \code{return.only.var.genes=TRUE};
default: FALSE).}

\item{return.only.var.genes}{Logical; if TRUE (default), \code{scale.data}
is subset to variable features only.}

\item{seed.use}{Integer; random seed for reproducibility (default: 1448145).
Set to NULL to skip setting a seed.}

\item{verbose}{Logical; whether to print progress messages (default: TRUE).}

\item{assay}{Name of assay to pull the count data from; default is 'RNA'}

\item{new.assay.name}{Name for the new assay containing the normalized data; default is 'SCT'}
}
\value{
A Seurat object with a new \code{SCT} assay containing:
\code{counts} (corrected UMIs), \code{data} (log1p counts), and
\code{scale.data} (Pearson residuals), plus \code{misc} for intermediate
\code{vst} outputs.
}
\description{
Perform a variance‐stabilizing transformation on UMI counts using
\code{sctransform::vst} (https://github.com/satijalab/sctransform). This
replaces the \code{NormalizeData} → \code{FindVariableFeatures} →
\code{ScaleData} workflow by fitting a regularized negative binomial model
per gene and returning:
}
\details{
- A new assay (default name “SCT”), in which:
  - \code{counts}: depth‐corrected UMI counts (as if each cell had uniform
    sequencing depth; controlled by \code{do.correct.umi}).
  - \code{data}: \code{log1p} of corrected counts.
  - \code{scale.data}: Pearson residuals from the fitted NB model (optionally
    centered and/or scaled).
  - \code{misc}: intermediate outputs from \code{sctransform::vst}.

When multiple \code{counts} layers exist (e.g. after \code{split()}),
each layer is modeled independently. A consensus variable‐feature set is
then defined by ranking features by how often they’re called “variable” 
across different layers (ties broken by median rank).

By default, \code{sctransform::vst} will drop features expressed in fewer
than five cells. In the multi-layer case, this can lead to consenus
variable-features being excluded from the output's \code{scale.data} when
a feature is "variable" across many layers but sparsely expressed in at 
least one.
}
\seealso{
\code{\link[sctransform]{vst}},
  \code{\link[sctransform]{get_residuals}},
  \code{\link[sctransform]{correct_counts}}
}
\concept{preprocessing}
