% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/preprocessing.R,
%   R/preprocessing5.R
\name{SCTransform}
\alias{SCTransform}
\alias{SCTransform.default}
\alias{SCTransform.Assay}
\alias{SCTransform.Seurat}
\alias{SCTransform.IterableMatrix}
\title{Perform sctransform-based normalization}
\usage{
SCTransform(object, ...)

\method{SCTransform}{default}(
  object,
  cell.attr,
  reference.SCT.model = NULL,
  do.correct.umi = TRUE,
  ncells = 5000,
  residual.features = NULL,
  variable.features.n = 3000,
  variable.features.rv.th = 1.3,
  vars.to.regress = NULL,
  latent.data = NULL,
  do.scale = FALSE,
  do.center = TRUE,
  clip.range = c(-sqrt(x = ncol(x = umi)/30), sqrt(x = ncol(x = umi)/30)),
  vst.flavor = "v2",
  conserve.memory = FALSE,
  return.only.var.genes = TRUE,
  seed.use = 1448145,
  verbose = TRUE,
  ...
)

\method{SCTransform}{Assay}(
  object,
  cell.attr,
  reference.SCT.model = NULL,
  do.correct.umi = TRUE,
  ncells = 5000,
  residual.features = NULL,
  variable.features.n = 3000,
  variable.features.rv.th = 1.3,
  vars.to.regress = NULL,
  latent.data = NULL,
  do.scale = FALSE,
  do.center = TRUE,
  clip.range = c(-sqrt(x = ncol(x = object)/30), sqrt(x = ncol(x = object)/30)),
  vst.flavor = "v2",
  conserve.memory = FALSE,
  return.only.var.genes = TRUE,
  seed.use = 1448145,
  verbose = TRUE,
  ...
)

\method{SCTransform}{Seurat}(
  object,
  assay = "RNA",
  new.assay.name = "SCT",
  reference.SCT.model = NULL,
  do.correct.umi = TRUE,
  ncells = 5000,
  residual.features = NULL,
  variable.features.n = 3000,
  variable.features.rv.th = 1.3,
  vars.to.regress = NULL,
  do.scale = FALSE,
  do.center = TRUE,
  clip.range = c(-sqrt(x = ncol(x = object[[assay]])/30), sqrt(x = ncol(x =
    object[[assay]])/30)),
  vst.flavor = "v2",
  conserve.memory = FALSE,
  return.only.var.genes = TRUE,
  seed.use = 1448145,
  verbose = TRUE,
  ...
)

\method{SCTransform}{IterableMatrix}(
  object,
  cell.attr,
  reference.SCT.model = NULL,
  do.correct.umi = TRUE,
  ncells = 5000,
  residual.features = NULL,
  variable.features.n = 3000,
  variable.features.rv.th = 1.3,
  vars.to.regress = NULL,
  latent.data = NULL,
  do.scale = FALSE,
  do.center = TRUE,
  clip.range = c(-sqrt(x = ncol(x = object)/30), sqrt(x = ncol(x = object)/30)),
  vst.flavor = "v2",
  conserve.memory = FALSE,
  return.only.var.genes = TRUE,
  seed.use = 1448145,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{UMI counts matrix}

\item{...}{Additional parameters passed to \code{sctransform::vst}}

\item{cell.attr}{A metadata with cell attributes}

\item{reference.SCT.model}{If not NULL, compute residuals for the object
using the provided SCT model; supports only log_umi as the latent variable.
If residual.features are not specified, compute for the top variable.features.n
specified in the model which are also present in the object. If
residual.features are specified, the variable features of the resulting SCT
assay are set to the top variable.features.n in the model.}

\item{do.correct.umi}{Place corrected UMI matrix in assay counts slot; default is TRUE}

\item{ncells}{Number of subsampling cells used to build NB regression; default is 5000}

\item{residual.features}{Genes to calculate residual features for; default is NULL (all genes).
If specified, will be set to VariableFeatures of the returned object.}

\item{variable.features.n}{Use this many features as variable features after
ranking by residual variance; default is 3000. Only applied if residual.features is not set.}

\item{variable.features.rv.th}{Instead of setting a fixed number of variable features,
use this residual variance cutoff; this is only used when \code{variable.features.n}
is set to NULL; default is 1.3. Only applied if residual.features is not set.}

\item{vars.to.regress}{Variables to regress out in a second non-regularized linear}

\item{latent.data}{Extra data to regress out, should be cells x latent data
regression. For example, percent.mito. Default is NULL}

\item{do.scale}{Whether to scale residuals to have unit variance; default is FALSE}

\item{do.center}{Whether to center residuals to have mean zero; default is TRUE}

\item{clip.range}{Range to clip the residuals to; default is \code{c(-sqrt(n/30), sqrt(n/30))},
where n is the number of cells}

\item{vst.flavor}{When set to 'v2' sets method = glmGamPoi_offset, n_cells=2000,
and exclude_poisson = TRUE which causes the model to learn theta and intercept
only besides excluding poisson genes from learning and regularization}

\item{conserve.memory}{If set to TRUE the residual matrix for all genes is never
created in full; useful for large data sets, but will take longer to run;
this will also set return.only.var.genes to TRUE; default is FALSE}

\item{return.only.var.genes}{If set to TRUE the scale.data matrices in output assay are
subset to contain only the variable genes; default is TRUE}

\item{seed.use}{Set a random seed. By default, sets the seed to 1448145. Setting
NULL will not set a seed.}

\item{verbose}{Whether to print messages and progress bars}

\item{assay}{Name of assay to pull the count data from; default is 'RNA'}

\item{new.assay.name}{Name for the new assay containing the normalized data; default is 'SCT'}
}
\value{
Returns a Seurat object with a new assay (named SCT by default) with
counts being (corrected) counts, data being log1p(counts), scale.data being
pearson residuals; sctransform::vst intermediate results are saved in misc
slot of the new assay.
}
\description{
This function calls sctransform::vst. The sctransform package is available at
https://github.com/satijalab/sctransform.
Use this function as an alternative to the NormalizeData,
FindVariableFeatures, ScaleData workflow. Results are saved in a new assay
(named SCT by default) with counts being (corrected) counts, data being log1p(counts),
scale.data being pearson residuals; sctransform::vst intermediate results are saved
in misc slot of new assay.
}
\seealso{
\code{\link[sctransform]{correct_counts}} \code{\link[sctransform]{get_residuals}}
}
\concept{preprocessing}
