% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{Load10X_Spatial}
\alias{Load10X_Spatial}
\title{Load a 10x Genomics Visium Spatial Experiment into a \code{Seurat} object}
\usage{
Load10X_Spatial(
  data.dir,
  filename = "filtered_feature_bc_matrix.h5",
  assay = "Spatial",
  slice = "slice1",
  bin.size = NULL,
  filter.matrix = TRUE,
  to.upper = FALSE,
  image = NULL,
  ...
)
}
\arguments{
\item{data.dir}{Directory containing the H5 file specified by \code{filename}
and the image data in a subdirectory called \code{spatial}}

\item{filename}{Name of H5 file containing the feature barcode matrix}

\item{assay}{Name of the initial assay}

\item{slice}{Name for the stored image of the tissue slice}

\item{bin.size}{Specifies the bin sizes to read in - defaults to c(16, 8)}

\item{filter.matrix}{Only keep spots that have been determined to be over
tissue}

\item{to.upper}{Converts all feature names to upper case. Can be useful when
analyses require comparisons between human and mouse gene names for example.}

\item{image}{\code{VisiumV1}/\code{VisiumV2} instance(s) - if a vector is 
passed in it should be co-indexed with \code{`bin.size`}}

\item{...}{Arguments passed to \code{\link{Read10X_h5}}}
}
\value{
A \code{Seurat} object
}
\description{
Load a 10x Genomics Visium Spatial Experiment into a \code{Seurat} object
}
\examples{
\dontrun{
data_dir <- 'path/to/data/directory'
list.files(data_dir) # Should show filtered_feature_bc_matrix.h5
Load10X_Spatial(data.dir = data_dir)
}

}
\concept{preprocessing}
