% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/preprocessing.R
\name{FindSpatiallyVariableFeatures}
\alias{FindSpatiallyVariableFeatures}
\alias{FindSpatiallyVariableFeatures.default}
\alias{FindSpatiallyVariableFeatures.Assay}
\alias{FindSpatiallyVariableFeatures.Seurat}
\title{Find spatially variable features}
\usage{
FindSpatiallyVariableFeatures(object, ...)

\method{FindSpatiallyVariableFeatures}{default}(
  object,
  spatial.location,
  selection.method = c("markvariogram", "moransi"),
  r.metric = 5,
  x.cuts = NULL,
  y.cuts = NULL,
  verbose = TRUE,
  ...
)

\method{FindSpatiallyVariableFeatures}{Assay}(
  object,
  slot = "scale.data",
  spatial.location,
  selection.method = c("markvariogram", "moransi"),
  features = NULL,
  r.metric = 5,
  x.cuts = NULL,
  y.cuts = NULL,
  nfeatures = nfeatures,
  verbose = TRUE,
  ...
)

\method{FindSpatiallyVariableFeatures}{Seurat}(
  object,
  assay = NULL,
  slot = "scale.data",
  features = NULL,
  image = NULL,
  selection.method = c("markvariogram", "moransi"),
  r.metric = 5,
  x.cuts = NULL,
  y.cuts = NULL,
  nfeatures = 2000,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat object, assay, or expression matrix}

\item{...}{Arguments passed to other methods}

\item{spatial.location}{Coordinates for each cell/spot/bead}

\item{selection.method}{Method for selecting spatially variable features.
 \itemize{
  \item \code{markvariogram}: See \code{\link{RunMarkVario}} for details
  \item \code{moransi}: See \code{\link{RunMoransI}} for details.
}}

\item{r.metric}{r value at which to report the "trans" value of the mark
variogram}

\item{x.cuts}{Number of divisions to make in the x direction, helps define
the grid over which binning is performed}

\item{y.cuts}{Number of divisions to make in the y direction, helps define
the grid over which binning is performed}

\item{verbose}{Print messages and progress}

\item{slot}{Slot in the Assay to pull data from}

\item{features}{If provided, only compute on given features. Otherwise,
compute for all features.}

\item{nfeatures}{Number of features to mark as the top spatially variable.}

\item{assay}{Assay to pull the features (marks) from}

\item{image}{Name of image to pull the coordinates from}
}
\description{
Identify features whose variability in expression can be explained to some
degree by spatial location.
}
\concept{preprocessing}
\concept{spatial}
