% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{ReadAlevinCsv}
\alias{ReadAlevinCsv}
\title{Load in data from Alevin pipeline}
\usage{
ReadAlevinCsv(base.path)
}
\arguments{
\item{base.path}{Directory containing the alevin/quant_mat*
files provided by Alevin.}
}
\value{
Returns a matrix with rows and columns labeled
}
\description{
Enables easy loading of csv format matrix provided by Alevin
ran with `--dumpCsvCounts` flags.
}
\examples{
\dontrun{
data_dir <- 'path/to/output/directory'
list.files(data_dir) # Should show alevin/quants_mat* files
expression_matrix <- ReadAlevinCsv(base.path = data_dir)
seurat_object = CreateSeuratObject(counts = expression_matrix)
}

}
\author{
Avi Srivastava
}
