% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snn.R
\name{BuildSNN}
\alias{BuildSNN}
\title{SNN Graph Construction}
\usage{
BuildSNN(object, genes.use = NULL, reduction.type = "pca",
  dims.use = NULL, k.param = 10, plot.SNN = FALSE, prune.SNN = 1/15,
  print.output = TRUE, distance.matrix = NULL, force.recalc = FALSE,
  filename = NULL, save.SNN = TRUE, nn.eps = 0)
}
\arguments{
\item{object}{Seurat object}

\item{genes.use}{A vector of gene names to use in construction of SNN graph
if building directly based on expression data rather than a dimensionally
reduced representation (i.e. PCs).}

\item{reduction.type}{Name of dimensional reduction technique to use in
construction of SNN graph. (e.g. "pca", "ica")}

\item{dims.use}{A vector of the dimensions to use in construction of the SNN
graph (e.g. To use the first 10 PCs, pass 1:10)}

\item{k.param}{Defines k for the k-nearest neighbor algorithm}

\item{plot.SNN}{Plot the SNN graph}

\item{prune.SNN}{Sets the cutoff for acceptable Jaccard index when
computing the neighborhood overlap for the SNN construction. Any edges with
values less than or equal to this will be set to 0 and removed from the SNN
graph. Essentially sets the strigency of pruning (0 --- no pruning, 1 ---
prune everything).}

\item{print.output}{Whether or not to print output to the console}

\item{distance.matrix}{Build SNN from distance matrix (experimental)}

\item{force.recalc}{Force recalculation of SNN.}

\item{filename}{Write SNN directly to file named here as an edge list
compatible with FindClusters}

\item{save.SNN}{Default behavior is to store the SNN in object@snn. Setting
to FALSE can be used together with a provided filename to only write the SNN
out as an edge file to disk.}

\item{nn.eps}{Error bound when performing nearest neighbor seach using RANN;
default of 0.0 implies exact nearest neighbor search}
}
\value{
Returns the object with object@snn filled
}
\description{
Constructs a Shared Nearest Neighbor (SNN) Graph for a given dataset. We
first determine the k-nearest neighbors of each cell. We use this knn graph
to construct the SNN graph by calculating the neighborhood overlap
(Jaccard index) between every cell and its k.param nearest neighbors.
}
\examples{

pbmc_small
# Compute an SNN on the gene expression level
pbmc_small <- BuildSNN(pbmc_small, genes.use = pbmc_small@var.genes)

# More commonly, we build the SNN on a dimensionally reduced form of the data
# such as the first 10 principle components.

pbmc_small <- BuildSNN(pbmc_small, reduction.type = "pca", dims.use = 1:10)

}
