% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{TransferIdent}
\alias{TransferIdent}
\title{Transfer identity class information (or meta data) from one object to another}
\usage{
TransferIdent(object.from, object.to, data.to.transfer = "ident",
  keep.existing = TRUE, add.cell.id1 = NULL)
}
\arguments{
\item{object.from}{Seurat object to transfer information from}

\item{object.to}{Seurat object to transfer information onto}

\item{data.to.transfer}{What data should be transferred over? Default is the
identity class ("ident"), but can also include any column in
object.from@meta.data}

\item{keep.existing}{For cells in object.to that are not present in
object.from, keep existing data? TRUE by default. If FALSE, set to NA.}

\item{add.cell.id1}{Prefix to add (followed by an underscore) to cells in
object.from. NULL by default, in which case no prefix is added.}
}
\value{
A Seurat object where object@ident or object@meta.data has been
appropriately modified
}
\description{
Transfers identity class information (or meta data) from one object to
another, assuming the same cell barcode names are in each. Can be very useful
if you have multiple Seurat objects that share a subset of underlying data.
}
\examples{
# Duplicate the test object and assign random new idents to transfer
pbmc_small@ident
pbmc_small2 <- SetIdent(object = pbmc_small, cells.use = pbmc_small@cell.names,
 ident.use = sample(pbmc_small@ident))
pbmc_small2@ident
pbmc_small <- TransferIdent(object.from = pbmc_small2, object.to = pbmc_small)
pbmc_small@ident

}
