% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction.R
\name{RunPHATE}
\alias{RunPHATE}
\title{Run PHATE}
\usage{
RunPHATE(object, cells.use = NULL, genes.use = NULL, assay.type = "RNA",
  max.dim = 2L, k = 15, alpha = 10, use.alpha = NA, n.landmark = 2000,
  potential.method = "log", t = "auto", knn.dist.method = "euclidean",
  mds.method = "metric", mds.dist.method = "euclidean", t.max = 100,
  npca = 100, plot.optimal.t = FALSE, verbose = 1, n.jobs = 1,
  seed.use = NA, reduction.name = "phate", reduction.key = "PHATE", ...)
}
\arguments{
\item{object}{Seurat object}

\item{cells.use}{Which cells to analyze (default, all cells)}

\item{genes.use}{If set, run PHATE on this subset of genes.
Not set (NULL) by default}

\item{assay.type}{Assay to pull data for (default: 'RNA')}

\item{max.dim}{Total number of dimensions to embed in PHATE.}

\item{k}{int, optional, default: 15
number of nearest neighbors on which to build kernel}

\item{alpha}{int, optional, default: 10
sets decay rate of kernel tails.
If NA, alpha decaying kernel is not used}

\item{use.alpha}{boolean, default: NA
forces the use of alpha decaying kernel
If NA, alpha decaying kernel is used for small inputs
(n_samples < n_landmark) and not used otherwise}

\item{n.landmark}{int, optional, default: 2000
number of landmarks to use in fast PHATE}

\item{potential.method}{string, optional, default: 'log'
choose from 'log' and 'sqrt'
which transformation of the diffusional operator is used
to compute the diffusion potential}

\item{t}{int, optional, default: 'auto'
power to which the diffusion operator is powered
sets the level of diffusion}

\item{knn.dist.method}{string, optional, default: 'euclidean'.
The desired distance function for calculating pairwise distances on the data.
If 'precomputed', `data` is treated as a
(n_samples, n_samples) distance or affinity matrix}

\item{mds.method}{string, optional, default: 'metric'
choose from 'classic', 'metric', and 'nonmetric'
which MDS algorithm is used for dimensionality reduction}

\item{mds.dist.method}{string, optional, default: 'euclidean'
recommended values: 'euclidean' and 'cosine'}

\item{t.max}{int, optional, default: 100.
Maximum value of t to test for automatic t selection.}

\item{npca}{int, optional, default: 100
Number of principal components to use for calculating
neighborhoods. For extremely large datasets, using
n_pca < 20 allows neighborhoods to be calculated in
log(n_samples) time.}

\item{plot.optimal.t}{boolean, optional, default: FALSE
If TRUE, produce a plot showing the Von Neumann Entropy
curve for automatic t selection.}

\item{verbose}{`int` or `boolean`, optional (default : 1)
If `TRUE` or `> 0`, print verbose updates.}

\item{n.jobs}{`int`, optional (default: 1)
The number of jobs to use for the computation.
If -1 all CPUs are used. If 1 is given, no parallel computing code is
used at all, which is useful for debugging.
For n_jobs below -1, (n.cpus + 1 + n.jobs) are used. Thus for
n_jobs = -2, all CPUs but one are used}

\item{seed.use}{int or `NA`, random state (default: `NA`)}

\item{reduction.name}{dimensional reduction name, specifies the position in
the object$dr list. phate by default}

\item{reduction.key}{dimensional reduction key, specifies the string before
the number for the dimension names. PHATE by default}

\item{...}{Additional arguments for `phateR::phate`}
}
\value{
Returns a Seurat object containing a PHATE representation
}
\description{
PHATE is a data reduction method specifically designed for visualizing
**high** dimensional data in **low** dimensional spaces.
To run, you must first install the `phate` python
package (e.g. via pip install phate). Details on this package can be
found here: \url{https://github.com/KrishnaswamyLab/PHATE}. For a more in depth
discussion of the mathematics underlying PHATE, see the bioRxiv paper here:
\url{https://www.biorxiv.org/content/early/2017/12/01/120378}.
}
\examples{
if (reticulate::py_module_available("phate")) {

# Load data
pbmc_small

# Run PHATE with default parameters
pbmc_small <- RunPHATE(object = pbmc_small)
# Plot results
DimPlot(object = pbmc_small, reduction.use = 'phate')

# Try smaller `k` for a small dataset, and larger `t` for a noisy embedding
pbmc_small <- RunPHATE(object = pbmc_small, k = 4, t = 12)
# Plot results
DimPlot(object = pbmc_small, reduction.use = 'phate')
1
# For increased emphasis on local structure, use sqrt potential
pbmc_small <- RunPHATE(object = pbmc_small, potential.method='sqrt')
# Plot results
DimPlot(object = pbmc_small, reduction.use = 'phate')
}

}
\references{
Moon K, van Dijk D, Wang Z, Burkhardt D, Chen W, van den Elzen A,
Hirn M, Coifman R, Ivanova N, Wolf G and Krishnaswamy S (2017).
"Visualizing Transitions and Structure for High Dimensional Data
Exploration." _bioRxiv_, pp. 120378. doi: 10.1101/120378
(URL: http://doi.org/10.1101/120378),
<URL: https://www.biorxiv.org/content/early/2017/12/01/120378>.
}
