% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{CombineIdent}
\alias{CombineIdent}
\title{Sets identity class information to be a combination of two object attributes}
\usage{
CombineIdent(object, attribute.1 = "ident", attribute.2 = "orig.ident")
}
\arguments{
\item{object}{Seurat object}

\item{attribute.1}{First attribute for combination. Default is "ident"}

\item{attribute.2}{Second attribute for combination. Default is "orig.ident"}
}
\value{
A Seurat object where object@ident has been appropriately modified
}
\description{
Combined two attributes to define identity classes. Very useful if, for
example, you have multiple cell types and multiple replicates, and you want
to group cells based on combinations of both.
}
\examples{
groups <- sample(c("group1", "group2", "group3"), size = 80, replace = TRUE)
celltype <- sample(c("celltype1", "celltype2", "celltype3"), size = 80, replace = TRUE)
new.metadata <- data.frame(groups = groups, celltype = celltype)
rownames(new.metadata) <- pbmc_small@cell.names
pbmc_small <- AddMetaData(object = pbmc_small, metadata = new.metadata)
pbmc_small <- CombineIdent(object = pbmc_small, attribute.1 = "celltype", attribute.2 = "groups")
pbmc_small@ident

}
