% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{ColorTSNESplit}
\alias{ColorTSNESplit}
\title{Color tSNE Plot Based on Split}
\usage{
ColorTSNESplit(object, node, color1 = "red", color2 = "blue",
  color3 = "gray", ...)
}
\arguments{
\item{object}{Seurat object}

\item{node}{Node in cluster tree on which to base the split}

\item{color1}{Color for the left side of the split}

\item{color2}{Color for the right side of the split}

\item{color3}{Color for all other cells}

\item{...}{Arguments passed on to \code{TSNEPlot}
\describe{
  \item{do.label}{FALSE by default. If TRUE, plots an alternate view where the center of each
cluster is labeled}
  \item{pt.size}{Set the point size}
  \item{label.size}{Set the size of the text labels}
  \item{cells.use}{Vector of cell names to use in the plot.}
  \item{colors.use}{Manually set the color palette to use for the points}
}}
}
\value{
Returns a tSNE plot
}
\description{
Returns a tSNE plot colored based on whether the cells fall in clusters
to the left or to the right of a node split in the cluster tree.
}
\examples{
pbmc_small
PlotClusterTree(pbmc_small)
ColorTSNESplit(pbmc_small, node = 6)

}
