% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{AddImputedScore}
\alias{AddImputedScore}
\title{Calculate imputed expression values}
\usage{
AddImputedScore(object, genes.use = NULL, genes.fit = NULL, s.use = 20,
  do.print = FALSE, gram = TRUE)
}
\arguments{
\item{object}{Seurat object}

\item{genes.use}{A vector of genes (predictors) that can be used for
building the LASSO models.}

\item{genes.fit}{A vector of genes to impute values for}

\item{s.use}{Maximum number of steps taken by the algorithm (lower values
indicate a greater degree of smoothing)}

\item{do.print}{Print progress (output the name of each gene after it has
been imputed).}

\item{gram}{The use.gram argument passed to lars}
}
\value{
Returns a Seurat object where the imputed values have been added to
object@imputed
}
\description{
Uses L1-constrained linear models (LASSO) to impute single cell gene
expression values.
}
\examples{
pbmc_small <- AddImputedScore(object = pbmc_small, genes.fit = "MS4A1")

}
