% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{ICHeatmap}
\alias{ICHeatmap}
\title{Independent component heatmap}
\usage{
ICHeatmap(object, ic.use = 1, cells.use = NULL, num.genes = 30,
  disp.min = -2.5, disp.max = 2.5, do.return = FALSE,
  col.use = PurpleAndYellow(), use.scale = TRUE, do.balanced = FALSE,
  remove.key = FALSE, label.columns = NULL, ...)
}
\arguments{
\item{object}{Seurat object}

\item{ic.use}{Components to use}

\item{cells.use}{A list of cells to plot. If numeric, just plots the top cells.}

\item{num.genes}{NUmber of genes to plot}

\item{disp.min}{Minimum display value (all values below are clipped)}

\item{disp.max}{Maximum display value (all values above are clipped)}

\item{do.return}{If TRUE, returns plot object, otherwise plots plot object}

\item{col.use}{Colors to plot.}

\item{use.scale}{Default is TRUE: plot scaled data. If FALSE, plot raw data on the heatmap.}

\item{do.balanced}{Plot an equal number of genes with both + and - scores.}

\item{remove.key}{Removes the color key from the plot.}

\item{label.columns}{Labels for columns}

\item{...}{Extra parameters passed to DimHeatmap}
}
\value{
If do.return==TRUE, a matrix of scaled values which would be passed
to heatmap.2. Otherwise, no return value, only a graphical output
}
\description{
Draws a heatmap focusing on a principal component. Both cells and genes are sorted by their
principal component scores. Allows for nice visualization of sources of heterogeneity
in the dataset."()
}
\examples{
pbmc_small <- RunICA(object = pbmc_small, ics.compute = 25, print.results = FALSE)
ICHeatmap(object = pbmc_small)

}
