% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{GenesInCluster}
\alias{GenesInCluster}
\title{GenesInCluster}
\usage{
GenesInCluster(object, cluster.num, max.genes = 1e+06)
}
\arguments{
\item{object}{Seurat object. Assumes DoKMeans has already been run}

\item{cluster.num}{K-means cluster(s) to return genes for}

\item{max.genes}{max number of genes to return}
}
\value{
A vector of genes who are members in the cluster.num k-means cluster(s)
}
\description{
After k-means analysis, previously run with DoKMeans, returns a set of genes associated with each cluster
}
\examples{
pbmc_small
# Cluster on genes only
pbmc_small <- DoKMeans(object = pbmc_small, k.genes = 3)
pbmc_small <- GenesInCluster(object = pbmc_small, cluster.num = 1)

}
