% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction.R
\name{AlignSubspace}
\alias{AlignSubspace}
\title{Align subspaces using dynamic time warping (DTW)}
\usage{
AlignSubspace(object, reduction.type, grouping.var, dims.align,
  num.genes = 30, show.plots = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{reduction.type}{reduction to align scores for}

\item{grouping.var}{Name of the grouping variable for which to align the scores}

\item{dims.align}{Dims to align, default is all}

\item{num.genes}{Number of genes to use in construction of "metagene"}

\item{show.plots}{show debugging plots}
}
\value{
Returns Seurat object with the dims aligned, stored in
 object@dr$reduction.type.aligned
}
\description{
Aligns subspaces so that they line up across grouping variable (only
implemented for case with 2 categories in grouping.var)
}
\examples{
\dontrun{
pbmc_small
# Requires CCA to have previously been run
# As CCA requires two datasets, we will split our test object into two just for this example
pbmc1 <- SubsetData(pbmc_small,cells.use = pbmc_small@cell.names[1:40])
pbmc2 <- SubsetData(pbmc_small,cells.use = pbmc_small@cell.names[41:80])
pbmc1@meta.data$group <- "group1"
pbmc2@meta.data$group <- "group2"
pbmc_cca <- RunCCA(pbmc1,pbmc2)
pbmc_cca <- AlignSubspace(pbmc_cca,reduction.type = "cca", grouping.var = "group", dims.align = 1:2)
}

}
