% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qhc.R
\name{qhc}
\alias{qhc}
\title{Quantile of Higher Criticism statitics under the null hypothesis.}
\usage{
qhc(p, n, beta, LS = F, ZW = F)
}
\arguments{
\item{p}{-  a scalar left probability that defines the quantile.}

\item{n}{- dimension parameter, i.e. the number of input statitics to construct HC statistic.}

\item{beta}{- search range parameter . Beta must be between 1/n and 1.}

\item{LS}{- if LS = T, then method of Li and Siegmund (2015) will be implemented.When n and q is very large, approximation method is prefered.}

\item{ZW}{- if ZW = T, then approximation method of Zhang and Wu will be implemented.}
}
\value{
Quantile of HC statistics.
}
\description{
Quantile of Higher Criticism statitics under the null hypothesis.
}
\examples{
## The 0.05 critical value of HC statistic when n = 10:
qhc(p=.95, n=10, beta=0.5)
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and Statistical Power of Optimal
Signal Detection Methods in Finite Samples", submitted.

2. Donoho, David; Jin, Jiashun. "Higher criticism for detecting sparse heterogeneous mixtures". Annals of Statistics 32 (2004).

3. Li, Jian; Siegmund, David. "Higher criticism: p-values and criticism". Annals of Statistics 43 (2015).
}
\seealso{
\code{\link{stat.hc}} for the definition of the statistic.
}

