% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{remove_connections.matrix}
\alias{remove_connections.matrix}
\title{Remove connections in a network}
\usage{
\method{remove_connections}{matrix}(x, prob_remove, run_checks = TRUE, ...)
}
\arguments{
\item{x}{The 'network', 'network_module', or 'matrix' object to modify.}

\item{prob_remove}{A value between 0 and 1. Each edge will be removed with
probability equal to \code{prob_remove}.}

\item{run_checks}{If \code{TRUE} and 'x' is a matrix, then it is checked that
'x' is an adjacency matrix. This catches the case where 'x' is a weighted
matrix, in which case the weights are removed and a warning is given.}

\item{...}{Additional arguments.}
}
\value{
The modified adjacency matrix.
}
\description{
Remove connections in a network
}
\examples{
# Create a random network with 10 nodes. 
nw <- random_network(20)
# Remove connections in the network each with probability 1/2.
nw_rewired <- remove_connections(nw, 0.5)
# Plot the two networks for comparison
g <- plot(nw)
plot(nw_rewired, g) # Pass in g to mirror the layout.
# Or plot the differential network.
plot_network_diff(nw, nw_rewired)
}
