\name{comparewithancestral}
\alias{comparewithancestral}
\title{Compares ancestral sequence with sequence alignment}

\description{Generates from a nexus tree file the possible ancestral sequence and compares this with the sequence alignment.}

\usage{comparewithancestral(path_to_file_sequence_alignment = NULL,
    path_to_file_nexus_tree = NULL, save_name_csv, 
    patnum_threshold = 1, significance_level = 0.05,
    A11, A12, A21, A22, B11, B12, B21, B22)}
    
\arguments{
  \item{path_to_file_sequence_alignment}{FASTA file with sequence alignment. For reference
    see example file.}
  \item{path_to_file_nexus_tree}{nexus tree file of sequences alignment. For reference see example file.}
  \item{save_name_csv}{name of file to which results are saved in csv format.}
  \item{patnum_threshold}{minimum number of patients per HLA type to consider in calculation.}
  \item{significance_level}{significance level in Fisher's exact test.}
  \item{A11}{position of start of first HLA A allele in header line of FASTA file.}
  \item{A12}{position of end of first HLA A allele in header line of FASTA file.}
  \item{A21}{position of start of second HLA A allele in header line of FASTA file.}
  \item{A22}{position of end of second HLA A allele in header line of FASTA file.}
  \item{B11}{position of start of first HLA B allele in header line of FASTA file.}
  \item{B12}{position of end of first HLA B allele in header line of FASTA file.}
  \item{B21}{position of start of second HLA B allele in header line of FASTA file.}
  \item{B22}{position of end of second HLA B allele in header line of FASTA file.}
}

\details{
  Features may be HLA types, indicated by four blocks in the FASTA
  comment lines. The positions of these blocks in the comment lines are
  defined by parameters A11, ..., B22. For patients with a homozygous
  HLA allele the second allele has to be "00" (without the double
  quotes). 

 Uses the R-packages ape and phangorn to create from a given nexus tree
 file the ancestral sequence. For every sequence position the ancestral amino acid
 is compared with the amino acid of every HLA type and with a Fisher's exact test
 the significant differences are calculated.

}

\value{Generates a csv file with p-values and q-values (generated by the
  R-package qvalue) for every HLA type and sequence position with a p-value
  below given threshold (significance_level).
}

\note{BEWARE! You have to name the FASTA sequences (= comment line in the file)
 so that the R-packages ape and phangorn can read and write them correctly. 
 It will replace any space character with "_" (without the double quotes)
 and ignore ":" (without the double quotes)!
}

\author{Bettina Budeus}

\examples{
#Input files
\dontrun{
fasta_input <- system.file("extdata", "Example_aa.fasta", package="SeqFeatR")
tree_input <- system.file("extdata", "Example_tree.nh", package="SeqFeatR")

#Usage
comparewithancestral(
	path_to_file_sequence_alignment=fasta_input,
	path_to_file_nexus_tree=tree_input,
	save_name_csv="hlaTree_results.csv",
	patnum_threshold=1,
	significance_level=0.05,
	A11=10,
	A12=11,
	A21=13,
	A22=14,
	B11=17,
	B12=18,
	B21=20,
	B22=21)
}
}
