% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SentimentDictionary.R
\name{compareDictionaries}
\alias{compareDictionaries}
\title{Compares two dictionaries}
\usage{
compareDictionaries(d1, d2)
}
\arguments{
\item{d1}{is the first sentiment dictionary of type \code{\link{SentimentDictionaryWordlist}}, 
\code{\link{SentimentDictionaryBinary}} or
\code{\link{SentimentDictionaryWeighted}}}

\item{d2}{is the first sentiment dictionary of type \code{\link{SentimentDictionaryWordlist}}, 
\code{\link{SentimentDictionaryBinary}} or
\code{\link{SentimentDictionaryWeighted}}}
}
\value{
Returns list with different metrics depending on dictionary type
}
\description{
Routine compares two dictionaries in terms of how similarities and differences. Among the 
calculated measures are the total of distinct words, the overlap between both 
dictionaries, etc.
}
\note{
Currently, this routine only supports the case where both dictionaries are of the
same type
}
\examples{
d1 <- SentimentDictionary(c("uncertain", "possible", "likely"))
d2 <- SentimentDictionary(c("rather", "intend", "likely"))
cmp <- compareDictionaries(d1, d2)

d1 <- SentimentDictionary(c("increase", "rise", "more"),
                          c("fall", "drop"))
d2 <- SentimentDictionary(c("positive", "rise", "more"),
                          c("negative", "drop"))
cmp <- compareDictionaries(d1, d2)

d1 <- SentimentDictionary(c("increase", "decrease", "exit"),
                          c(+1, -1, -10),
                          rep(NA, 3))
d2 <- SentimentDictionary(c("increase", "decrease", "drop", "neutral"),
                          c(+2, -5, -1, 0),
                          rep(NA, 4))
cmp <- compareDictionaries(d1, d2)
}
\seealso{
\code{\link{SentimentDictionaryWordlist}}, 
\code{\link{SentimentDictionaryBinary}}, 
\code{\link{SentimentDictionaryWeighted}} for the specific classes
}
\keyword{dictionary}
