% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.dictionaries.R
\name{load.dictionaries}
\alias{load.dictionaries}
\title{Load Dictionaries}
\usage{
load.dictionaries(..., add.path = NULL)
}
\arguments{
\item{...}{Character.
Dictionaries to load

Dictionaries in your global environment
MUST be objects called \code{"*.dictionary"} (see examples)}

\item{add.path}{Character.
Path to additional dictionaries to be found.
DOES NOT search recursively (through all folders in path)
to avoid time intensive search.
Set to \code{"choose"} to open an interactive directory explorer

\code{\link[SemNetDictionaries]{dictionaries}} will identify dictionaries in the \code{\link{SemNetDictionaries}} package

\code{\link[SemNetDictionaries]{find.dictionaries}} will identify dictionaries on your computer}
}
\value{
Returns a vector of unique words that have been combined
and alphabetized from the specified dictionaries
}
\description{
A wrapper function to load dictionaries into
the 'SemNetCleaner' package. Searches for dictionaries in \code{R}'s global
environment, the \code{\link{SemNetDictionaries}} package, and on your computer.
Outputs a unique word list that is combined from all dictionaries entered 
in the \code{dictionary} argument
}
\examples{
# Find dictionaries to load
dictionaries()

# Load "animals" dictionary
load.dictionaries("animals")

# Create a dictionary
new.dictionary <- append.dictionary("words", "are", "fun")

# Load created dictionary
load.dictionaries("new")

# Load animals and new dictionary
load.dictionaries("animals", "new")

# Single letter dictionary
load.dictionaries("d")

# Multiple letters dictionary
load.dictionaries("a", "d")

# Category and letters dictionary
load.dictionaries("animals", "a")

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
