% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SettingsObjects.R
\name{createCreateSccsIntervalDataArgs}
\alias{createCreateSccsIntervalDataArgs}
\title{Create a parameter object for the \code{\link[=createSccsIntervalData]{createSccsIntervalData()}} function}
\usage{
createCreateSccsIntervalDataArgs(
  eraCovariateSettings,
  ageCovariateSettings = NULL,
  seasonalityCovariateSettings = NULL,
  calendarTimeCovariateSettings = NULL,
  minCasesForTimeCovariates = 10000,
  endOfObservationEraLength = 30,
  eventDependentObservation = FALSE
)
}
\arguments{
\item{eraCovariateSettings}{Either an object of type \code{EraCovariateSettings} as created using the \code{\link[=createEraCovariateSettings]{createEraCovariateSettings()}} function, or a list of such objects.}

\item{ageCovariateSettings}{An object of type \code{AgeCovariateSettings} as created using the \code{\link[=createAgeCovariateSettings]{createAgeCovariateSettings()}} function.}

\item{seasonalityCovariateSettings}{An object of type \code{SeasonalityCovariateSettings} as created using the \code{\link[=createSeasonalityCovariateSettings]{createSeasonalityCovariateSettings()}} function.}

\item{calendarTimeCovariateSettings}{An object of type \code{CalendarTimeCovariateSettings} as created using the \code{\link[=createCalendarTimeCovariateSettings]{createCalendarTimeCovariateSettings()}} function.}

\item{minCasesForTimeCovariates}{Minimum number of cases to use to fit age, season and calendar time splines. If needed (and available), cases that are not exposed will be included.}

\item{endOfObservationEraLength}{Length in days of the probe that is inserted at the end of a patient's
observation time. This probe will be used to test whether there is event-
dependent observation end. Set to 0 to not include the probe.}

\item{eventDependentObservation}{Should the extension proposed by Farrington et al. be used to adjust for event-dependent observation time?}
}
\value{
An object of type \code{CreateSccsIntervalDataArgs}.
}
\description{
Create a parameter object for the \code{\link[=createSccsIntervalData]{createSccsIntervalData()}} function
}
\details{
Create an object defining the parameter values.
}
\references{
Farrington, C. P., Anaya-Izquierdo, A., Whitaker, H. J., Hocine, M.N., Douglas, I., and Smeeth, L.
(2011). Self-Controlled case series analysis with event-dependent observation periods. Journal of
the American Statistical Association 106 (494), 417-426
}
