% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulation}
\alias{simulation}
\alias{simulation_cor}
\alias{simulation_X}
\alias{simulation_DATA}
\alias{compsim}
\alias{compsim.simuls}
\title{Miscellaneous simulation functions}
\usage{
simulation_cor(group, cor_group, v = 1)

simulation_X(N, Cor)

simulation_DATA(X, supp, minB, maxB, stn)

compsim(x, ...)

\method{compsim}{simuls}(x, result.boost, level = 1, ...)
}
\arguments{
\item{group}{A numeric vector. Group membership of each of the variables.}

\item{cor_group}{A numeric vector. Intra-group Pearson correlation.}

\item{v}{A numeric value. The diagonal value of the generated matrix.}

\item{N}{A numeric value. The number of observations.}

\item{Cor}{A numeric matrix. A correlation matrix to be used for random sampling.}

\item{X}{A numeric matrix. Observations*variables.}

\item{supp}{A numeric vector. The true predictors.}

\item{minB}{A numeric value. Minimum absolute value for a beta coefficient.}

\item{maxB}{A numeric value. Maximum absolute value for a beta coefficient.}

\item{stn}{A numeric value. A scaling factor for the noise in the response. The higher, the smaller the noise.}

\item{x}{List. Simulated dataset.}

\item{...}{For compatibility issues.}

\item{result.boost}{Row matrix of numerical value. Result of selecboost for a given c0.}

\item{level}{List. Threshold for proportions of selected variables.}
}
\value{
\code{simulation_cor} returns a numeric matrix.

\code{simulation_X} returns a numeric matrix.

\code{simulation_DATA} returns a list.

\code{compsim.simuls} returns a numerical vector.
}
\description{
Define several simulation functions to be used in the demos of the package.
}
\details{
\code{simulation_cor} returns a numeric symetric matrix c whose order
is the number of variables. An entry \eqn{c_{i,j}} is equal to
\itemize{
  \item \eqn{i=j}, entries on the diagonal are equal to the v value
  \item \eqn{i<>j}, 0 if the variable i and j do not belong to the same group
  \item \eqn{i<>j}, \code{cor_group[k]} if the variable i and j belong to the group k
}

\code{simulation_X} returns a numeric matrix of replicates (by row) of
random samples generated according to the Cor matrix.

\code{simulation_DATA} returns a list with the X matrix, the response vector Y,
the true predictors, the beta coefficients, the scaling factor and the standard deviation.

\code{compsim.simuls} computes recall (sensitivity), precision (positive predictive value), and several Fscores (non-weighted Fscore, F1/2 and F2 weighted Fscores).
}
\examples{
N<-10
group<-c(rep(1:2,5))
cor_group<-c(.8,.4)
supp<-c(1,1,1,0,0,0,0,0,0,0)
minB<-1
maxB<-2
stn<-5
C<-simulation_cor(group,cor_group)

set.seed(314)
X<-simulation_X(10,C)
G<-abs(cor(X))
hist(G[lower.tri(G)])

set.seed(314)
DATA_exemple<-simulation_DATA(X,supp,1,2,stn)

set.seed(314)
result.boost = fastboost(DATA_exemple$X, DATA_exemple$Y, steps.seq = .7, c0lim = FALSE,
use.parallel = FALSE, B=10)
compsim(DATA_exemple, result.boost, level=.7)

}
\references{
\emph{selectBoost: a general algorithm to enhance the performance of variable selection methods in correlated datasets}, Frédéric Bertrand, Ismaïl Aouadi, Nicolas Jung, Raphael Carapito, Laurent Vallat, Seiamak Bahram, Myriam Maumy-Bertrand, \url{https://arxiv.org/abs/1810.01670}
}
\seealso{
\code{\link[glmnet]{glmnet}}, \code{\link[glmnet]{cv.glmnet}}, \code{\link{AICc_BIC_glmnetB}}, \code{\link[lars]{lars}}, \code{\link[lars]{cv.lars}}, \code{\link[msgps]{msgps}}
}
\author{
Frederic Bertrand, \email{frederic.bertrand@math.unistra.fr} with contributions from Nicolas Jung.
}
\concept{Simulation functions}
