% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Frequency.R
\encoding{UTF-8}
\name{freq}
\alias{freq}
\alias{freq.default}
\title{Simple Frequency Table}
\usage{
freq(x, weighs = NULL, breaks = graphics::hist(x, plot = FALSE)$breaks,
  digits = 3, include.lowest = TRUE, order = c("desc", "asc", "level",
  "name"), perc = FALSE, useNA = c("no", "ifany", "always"), ...)

\method{freq}{default}(x, weighs = NULL, breaks = graphics::hist(x, plot =
  FALSE)$breaks, digits = 3, include.lowest = TRUE, order = c("desc",
  "asc", "level", "name"), perc = FALSE, useNA = c("no", "ifany", "always"),
  ...)
}
\arguments{
\item{x}{A vector of values for which the frequency is desired.}

\item{weighs}{A vector of weights.}

\item{breaks}{one of: 1) a vector giving the breakpoints between histogram
cells; 2) a function to compute the vector of breakpoints; 3) a single
number giving the number of cells for the histogram; 4) a character string
naming an algorithm to compute the number of cells (see 'Details'); 5) a
function to compute the number of cells.}

\item{digits}{The number of significant digits required.}

\item{include.lowest}{Logical; if \code{TRUE}, an x[i] equal to the breaks value will be included in the first (or last) category or bin.}

\item{order}{The order method.}

\item{perc}{logical; if \code{TRUE} percents are returned.}

\item{useNA}{Logical; if \code{TRUE} NA's values are included.}

\item{\dots}{Additional arguements (currently ignored)}
}
\description{
Creates a frequency table or data frame.
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}.
}
\seealso{
\code{\link{Frequency}}, \code{\link{Crosstable}}.
}

