% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Herfindahl.R
\encoding{UTF-8}
\name{Herfindahl}
\alias{Herfindahl}
\alias{Herfindahl.default}
\alias{Simpson}
\title{Herfindahl Index of Concentration}
\usage{
Herfindahl(x, n = rep(1, length(x)), base = 1, na.rm = FALSE, ...)

\method{Herfindahl}{default}(x, n = rep(1, length(x)), base = NULL,
  na.rm = FALSE, ...)
}
\arguments{
\item{x}{a vector of data values of non-negative elements.}

\item{n}{a vector of frequencies of the same length as \code{x}.}

\item{base}{a parameter of the concentration measure (if \code{NULL}, the default parameter (1.0) is used instead).}

\item{na.rm}{a logical. Should missing values be removed? The Default is set to \code{na.rm=FALSE}.}

\item{\dots}{additional arguements (currently ignored)}
}
\description{
Calculates the Herfindahl Index of concentration.
}
\details{
This index is also known as the \emph{Simpson Index} in ecology, the \emph{Herfindahl-Hirschman Index (HHI)} in economics, and as the \emph{Effective Number of Parties (ENP)} in political science.
}
\examples{
# generate a vector (of incomes)
x <- c(778, 815, 857, 888, 925, 930, 965, 990, 1012)

# compute the Herfindahl coefficient with base=1
Herfindahl(x, base=1)


}
\references{
Cowell, F. A. (2000) Measurement of Inequality in Atkinson, A. B. / Bourguignon, F. (Eds): \emph{Handbook of Income Distribution}. Amsterdam.

Cowell, F. A. (1995) \emph{Measuring Inequality} Harvester Wheatshef: Prentice Hall.
}
\seealso{
\code{\link{Atkinson}}, \code{\link{Rosenbluth}},
\code{\link{PoliticalDiversity}}, \code{\link{Gini}}. For more details see the Indices vignette: \code{vignette("Indices", package = "SciencesPo")}
}

