% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TESTS.R
\name{jarque.bera}
\alias{jarque.bera}
\title{Jarque-Bera test for normality}
\usage{
jarque.bera(x)
}
\arguments{
\item{x}{A numeric vector of data.}
}
\description{
This function performs the Jarque-Bera test on the given data sample to determine if the data are sample drawn from a normal population.
}
\details{
The Jarque-Bera statistic is chi-square distributed with two degrees of freedom. Under the hypothesis of normality, data should be symmetrical (i.e. skewness should be equal to zero) and have skewness chose to three.
}
\examples{
set.seed(1234)
x <- rnorm(1000)
jarque.bera(x)
}
\references{
Jarque, C. M., Bera, A. K. (1980) Efficient test for normality, homoscedasticity and serial independence of residuals,
Economic Letters, Vol. 6 Issue 3, 255-259.
}

