% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/true.median.R
\encoding{UTF-8}
\name{true.median}
\alias{true.median}
\title{Calculates the true median}
\usage{
true.median(x, h = 1)
}
\arguments{
\item{x}{a numeric vector.}

\item{h}{width of measurement unit. Default is \code{h=1}.}
}
\description{
Usually median for data with ties, the tied values are treated as exactly the same. For instance, taking a median of 3, 3, 4, 4, 4 will be 4. However, the values to be measured are usually rounded off, so that we can assume evenly distributed true values for tied values. For instance, the previous data can be treated as rounded values of 2.75, 3.25, 11/3, 4, 13/3. From this viewpoint, the true median of 3, 3, 4, 4, 4 could be 11/3 (=3.66...).
}
\examples{
s <-c(3, 3, 4, 4, 4)
true.median(s)
median(s)
z <- c(2.75, 3.25, 11/3, 4, 13/3)
true.median(z)
median(z)
}
\author{
Daniel Marcelino \email{dmarcelino@live.com}
}

