% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{sampleCovariance}
\alias{sampleCovariance}
\title{Calculate the Sample Covariance}
\usage{
sampleCovariance(x, y, verbose = TRUE)
}
\arguments{
\item{x}{One of two vectors whose sample covariance is to be calculated.}

\item{y}{The other vector.}

\item{verbose}{If \code{TRUE}, prints sample covariance; if not, not. Default is \code{verbose = TRUE}.}
}
\value{
The sample covariance between x and y.
}
\description{
Computes the sample covariance between two vectors. The Covariance provides a measure of the strength of the correlation between two or more sets of random variates. The covariance for two random variates \code{x} and \code{y}, each with sample size \code{n}, is defined by the expectation value variables \verb{cov(x, y) = (x - \mu_x)(y - \mu_y)}. For uncorrelated variables, \code{cov(x, y) = 0}.
}
\details{
x and y must have the same length, greater than one  with no missing values.
}
\examples{
# Some random data:
df = data.frame(id=1:20, x=rnorm(20, mean=2, sd=.5),
 y=rnorm(20, mean=5, sd=2) )
  sampleCovariance(df$x, df$y)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\references{
Based on the Google's R Guide Style.
}

