% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{detail}
\alias{detail}
\title{Method to Produce Descriptive Statistics Summary}
\usage{
detail(data, by = NULL, basic = TRUE, na.rm = TRUE, trim = 0.2,
  type = 2, k = 1)

detail(data, by = NULL, basic = TRUE, na.rm = TRUE, trim = 0.2,
  type = 2, k = 1)
}
\arguments{
\item{data}{a data object (vector or data.frame).}

\item{by}{a factor variable}

\item{basic}{indicates if only a short version of the descriptive table should be returned, the default is \code{basic=TRUE}.}

\item{na.rm}{a logical value for \code{na.rm}, default is \code{na.rm=TRUE}.}

\item{trim}{is the proportion of the data to be replaced for estimating the average}

\item{type}{a numeric value (fraction) to be trimmed. The value in trim will be discarded from the top and bottom of data. See in details below}

\item{k}{a numeric value for observations in the data set to be discarded while computing the winsorized mean. See details below}

\item{...}{Parameters which are typically ignored}
}
\value{
A data.frame of descriptive statistics

A data frame containing the require computations
}
\description{
Method to Produce Descriptive Statistics Summary

This function provides up to 14 statistics for an entire data object: number of cases, mean, standard deviation, variance, standard error, median, mad (median absolute deviation), trimmed and winsorized means, range, minimum, maximum, skewness, and kurtosis. Statistics for a factor variable might be computed based on its `levels`, and is shown accompained whit ans \verb{"*"}.
}
\details{
Trimming is not winsorizing. The winsorization process is more complex than simply excluding data. For example, while in a trimmed estimator the extreme values are discarded, in a winsorized estimator, they are rather replaced by certain percentiles.
}
\examples{
#load some data
data(ssex)

# To apply the function
detail(ssex, trim = 0.5, k = 3)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}

Daniel Marcelino, \email{dmarcelino@live.com}
}
\references{
Venables, W. N. and Ripley, B. D. (2002) \emph{Modern Applied Statistics with S.}. Springer.
}
\keyword{Descriptive}
\keyword{Tables}

