\encoding{UTF-8}
\name{get.enp}
\alias{get.enp}
\title{The Effective Number of Parties 
	}
\description{
The effective number of parties is a measure of fragmentation. The idea behind it is to count parties and, at the same time, to weight the count by their relative strength.}
\usage{
get.enp(seats=NULL, votes=NULL, total=NA, method = "Laakso/Taagepera")
}
\arguments{
  \item{seats}{ A numeric value or a vector (may be as proportion).
}
  \item{votes}{A numeric value or a vector as the number of votes received by each party. 
}
  \item{total}{A numeric value either of seats or votes.}
  
  \item{method}{The method to use to compute  ENP, the default is Laakso/Taagepera. }
}
\details{ Very often, political analysts say things like \sQuote{two-party system} and \sQuote{multi-party system} to refer to a particular kind of political party system. However, this alone does not tell exactly how fragmented--or concentrated a party system is.  For instance, after the 2010 election in Brazil, 22 parties were represented in the Lower Chamber, but nine of them returned only 28 MPs between them. Thus, an algorithm to (weigh) or to calculate the \bold{Effective Number of Parties} in such circumstances helps to go beyond the simple number of parties. A widely accepted algorithm was proposed by M. Laakso and R. Taagepera: \deqn{N = \frac{1}{\sum p_i^2}}{N = 1/ \sum p_i^2}.
where \bold{N} denotes the effective number of parties and \bold{p_i} denotes the ith party's fraction of the seats.
The same process can be used for vote share for each party. This formula is the reciprocal of a well-known concentration index (the Herfindahl-Hirschman index) used in economics to study the degree to which ownership of firms in an industry is concentrated. 

Laakso and Taagepera correctly saw that the effective number of parties is simply an instance of the inverse measurement problem to that one. The index makes rough but fairly reliable international comparisons possible.

The \bold{Least squares index (LSq)} is a measure of disproportionality amount generated by an election outcome. That is, the disparity between the distribution of votes at the election and the allocation of seats.
 
Grigorii Golosov proposes a new method to compute the effective number of parties (\bold{Golosov}). This new method give much more importance to
}
\value{
Numeric values.
}
\references{
Gallagher, Michael and Paul Mitchell (2005) \emph{The Politics of Electoral Systems.} Oxford University Press.
Golosov, Grigorii (2010) The Effective Number of Parties: A New Approach, \emph{Party Politics,} \bold{16:} 171--192. \bold{DOI: 10.1177/1354068809339538}.
Laakso, Markku and Rein Taagepera (1979) Effective Number of Parties: A Measure with Application to West Europe, \emph{Comparative Political Studies,} \bold{12:} 3-–27. \bold{DOI: 10.1177/001041407901200101}.
Nicolau, Jairo (2008) \emph{Sistemas Eleitorais.} Rio de Janeiro, FGV.
Taagepera, Rein and Matthew S. Shugart (1989) \emph{Seats and Votes: The Effects and Determinants of Electoral Systems.} New Haven: Yale University Press.
}
\author{
	Daniel Marcelino <dmarcelino@live.com>
}
\note{ 
So far, I have implemented the following methods: LSq, Laakso and Taagepera, and Golosov.
}

\examples{
# Here are some examples of data entry using proportions.  
A <- c(.75,.25)
B <- c(.35,.35,.30)
C <- c(.75,.10,rep(0.01,15))
D <- c(.55,rep(.10,3), rep(0.01,15))
E <- c(.15,rep(.15,5),0.1)

# appply

get.enp(seats=A, votes=NULL, total=1)

get.enp(seats=A, votes=NULL, total=1, method="Golosov")

# Non-trivial example: 
# 2010 Election outcome
# party = c("PT","PMDB","PSDB", "DEM","PR","PP","PSB","PDT","PTB", "PSC","PV",
# "PC do B","PPS","PRB", "PMN", "PT do B", "PSOL","PHS","PRTB","PRP","PSL","PTC")
# votes = c(13813587, 11692384, 9421347, 6932420, 7050274, 5987670, 6553345, 
# 4478736, 3808646, 2981714,2886633, 2545279, 2376475, 1659973, 1026220, 
# 605768, 968475, 719611, 283047, 232530, 457490, 563145)

seats10 = c(88,79,53,43,41,41,34,28,21,17,15,15,12,8,4,3,3,2,2,2,1,1)/513

get.enp(seats=seats10, votes=NULL, total=NULL, method="Golosov")

# 2014 Election outcome
seats14 = c(70,66,55,37,38,34,34,26,22,20,19,15,12,11,10,9,8,5,4,3,3,3,2,2,2,1,1,1)/513

get.enp(seats=seats14, votes=NULL, total=NULL, method="Golosov")

}
\keyword{ political behaviour }
\keyword{ descriptive stats }
