% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_csv_reader.R
\name{multiple_csv_reader}
\alias{multiple_csv_reader}
\title{Read Multiple CSV files into R
This function reads multiple CSVs in a directory must be same structure.}
\usage{
multiple_csv_reader(file_path, rows_to_skip = 0, col_names = TRUE)
}
\arguments{
\item{file_path}{The Directory in which the files are located}

\item{rows_to_skip}{The number of rows from the top to be excluded}

\item{col_names}{If columns are named; defaults to TRUE}
}
\value{
a data frame object full of file paths
}
\description{
Read Multiple CSV files into R
This function reads multiple CSVs in a directory must be same structure.
}
\examples{
library(SangerTools)
file_path = 'my_file_path_where_csvs_are_stored'
if (length(SangerTools::multiple_csv_reader(file_path))==0){
 message("This won't work without changing the variable input to a local file path with CSVs in")
}
}
