% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SILOThiessenShp.R
\name{SILOThiessenShp}
\alias{SILOThiessenShp}
\title{Function to generate Thiessen polygons from SILO sites}
\usage{
SILOThiessenShp(SILOdata, path, shpname)
}
\arguments{
\item{SILOdata}{- data loaded from SILO based on site list}

\item{path}{- file path to save Thiessen polygon shapefile}

\item{shpname}{- filename to save ESRI shapefile (no extension)}
}
\value{
A simple feature geometry (sf::sfc object) of the polgyons created. Shape file saved to path \\ shpname
}
\description{
Function to generate Thiessen polygons from SILO sites
}
\examples{
 
\dontrun{
X<-SILOLoad(c("24001","24002","24003"),path="./SWTools/extdata")
p<-SILOThiessenShp(X,tempdir(),"Theissens")
a<-SILOSiteSummary(X)
ggplot(p)+geom_sf(aes(fill=AnnualRainfall))+
geom_point(data=a,aes(Longitude,Latitude))+
geom_text(data=a,aes(Longitude,Latitude,label=Site),nudge_y = 0.02)
}
}
