% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVN.R
\name{SVN_clusters}
\alias{SVN_clusters}
\title{Find clusters in Statistically Validated Networks}
\usage{
SVN_clusters(links, cluster.method = "infomap")
}
\arguments{
\item{links}{an object obtained from the SVN_links function}

\item{cluster.method}{a string, either "infomap" or "louvain", that selects the clustering method}
}
\value{
an igraph communities object
}
\description{
Find clusters in Statistically Validated Networks
}
\examples{
 M=matrix(rbinom(200,size = 1,0.5),nrow=50)
mylinks=SVN_links(M)
# no links, then
print(mylinks)

# another example
x=c(1,0,0,0,0,0,1,1,1,1,0,0)
xx=c(1,1,0,0,0,0,1,1,1,1,0,0)
xrev=rev(x)
w=sample(x,length(x))
M=rbind(x,xx,xrev,w)
mylinks=SVN_links(M)

## if one wants clusters as well
myclusters=SVN_clusters(mylinks)

}
