% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode_osm.R
\name{geocode_osm}
\alias{geocode_osm}
\title{Geocode addresses with OpenStreetMap}
\usage{
geocode_osm(
  query,
  match_num = 1,
  return_all = FALSE,
  details = FALSE,
  user_agent = NULL
)
}
\arguments{
\item{query}{Address or place name to be geocoded. Character string.}

\item{match_num}{If query matches multiple locations, which match to return? Default is 1 (highest-ranking match, by relevance). Numeric.}

\item{return_all}{Should all matches be returned? Overrides \code{match_num} if \code{TRUE}. Default is \code{FALSE}. Logical.}

\item{details}{Should detailed results be returned? Default is \code{FALSE}. Logical.}

\item{user_agent}{Valid User-Agent identifying the application for OSM-Nominatum. If none supplied, function will attempt to auto-detect. Character string.}
}
\value{
A \code{data.frame} object. If \code{details=FALSE}, contains fields
\itemize{
 \item "query". User-supplied address query(ies). Character string.
 \item "osm_id". OpenStreetMap ID. Character string.
 \item "address". OpenStreetMap address. Character string.
 \item "longitude". Horizontal coordinate. Numeric.
 \item "latitude". Vertical coordinate. Numeric.
 }
If \code{details=TRUE}, contains additional fields
\itemize{
 \item "osm_type". OpenStreetMap ID. Character string.
 \item "importance". Relevance of Nominatum match to query, from 0 (worst) to 1 (best). Numeric.
 \item "bbox_ymin". Minimum vertical coordinate of bounding box. Numeric.
 \item "bbox_ymax". Maximum vertical coordinate of bounding box. Numeric.
 \item "bbox_xmin". Minimum horizontal coordinate of bounding box. Numeric.
 \item "bbox_xmax". Maximum horizontal coordinate of bounding box. Numeric.
 }
}
\description{
Function to find geographic coordinates of addresses and place names, using OpenStreetMap's Nominatum API.
}
\details{
Note that Nominatim Usage Policy stipulates an absolute maximum of 1 request per second (\url{https://operations.osmfoundation.org/policies/nominatim/}). For batch geocoding of multiple addresses, please use \code{\link[SUNGEO]{geocode_osm_batch}}.
}
\examples{
# Geocode an address (top match only)
\dontrun{
geocode_osm("Michigan Stadium")
}
# Return detailed results for top match
\dontrun{
geocode_osm("Michigan Stadium", details=TRUE)
}
# Return detailed results for all matches
\dontrun{
geocode_osm("Michigan Stadium", details=TRUE, return_all = TRUE)
}
}
