% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_legacy_to_current_std.R
\name{as_multiomics}
\alias{as_multiomics}
\title{Convert legacy objects (e.g., from \code{simulate_twoOmicsData()}) to the
current standardized structure used by downstream tools.}
\usage{
as_multiomics(x)
}
\arguments{
\item{x}{A list-like legacy simulation object (e.g., produced by
\code{simulate_twoOmicsData()} or similar helpers). May also be a list with
element \code{omics} that is itself a list of matrices.}
}
\value{
A standardized list with components:
\itemize{
\item \code{concatenated_datasets} — list of one matrix \code{cbind(omic1, omic2, ...)}.
\item \code{omics} — named list of matrices (samples x features).
\item \code{list_alphas} — per-factor sample scores (named \code{alpha1}, \code{alpha2}, ...).
\item \code{list_betas} — list per-omic with per-factor loadings (named \code{beta1}, \code{beta2}, ...).
\item \code{signal_annotation} — list with \code{samples} and \code{features} indices per factor and per-omic.
\item \code{factor_structure} — best-effort label: "shared", "unique", or "mixed".
\item \code{factor_map} — which omics each factor loads on.
}
}
\description{
Normalizes outputs that may contain fields like \code{omic.one}, \code{omic.two},
\code{list_betas}/\code{beta}, and \code{list_deltas}/\code{delta} into a unified structure with
\code{omics}, \code{list_betas} (per-omic), \code{signal_annotation} (samples and features),
and a \code{factor_map}. If the input already matches the current schema, it is
returned unchanged.
}
\details{
Coerce legacy simulation outputs to the current multi-omics schema
}
