% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDiag.R
\name{getDiag}
\alias{getDiag}
\title{Make diagnostic plots}
\usage{
getDiag(inla_mod, field = c("space", "time", "spacetime")[1],
  year_range = c(1985, 2019), year_label = c("85-89", "90-94", "95-99",
  "00-04", "05-09", "10-14", "15-19"), Amat = NULL, CI = 0.95)
}
\arguments{
\item{inla_mod}{output from \code{\link{fitINLA}}}

\item{field}{which random effects to plot. It can be one of the following: space, time, and spacetime.}

\item{year_range}{Entire range of the years (inclusive) defined in year_label. To be deprecated and imputed from the fitted object in the next version of SUMMER.}

\item{year_label}{vector of year string vector}

\item{Amat}{adjacency matrix}

\item{CI}{Desired level of credible intervals}
}
\value{
List of diagnostic plots
}
\description{
Make diagnostic plots
}
\examples{
\dontrun{
  data(DemoMap)
  years <- levels(DemoData[[1]]$time)
  
  # obtain direct estimates
  data <- getDirectList(births = DemoData, 
  years = years,  
  regionVar = "region", timeVar = "time", 
  clusterVar = "~clustid+id", 
  ageVar = "age", weightsVar = "weights", 
  geo.recode = NULL)
  # obtain direct estimates
  data_multi <- getDirectList(births = DemoData, years = years,
    regionVar = "region",  timeVar = "time", clusterVar = "~clustid+id",
    ageVar = "age", weightsVar = "weights", geo.recode = NULL)
  data <- aggregateSurvey(data_multi)
  
  #  national model
  years.all <- c(years, "15-19")
  fit1 <- fitINLA(data = data, geo = DemoMap$geo, Amat = DemoMap$Amat, 
    year_label = years.all, year_range = c(1985, 2019), 
    rw = 2, is.yearly=FALSE, m = 5)
random.time <- getDiag(fit1, field = "time", year_label = years.all, #' year_range = c(1985, 2019))
  random.space <- getDiag(fit1, field = "space", Amat = DemoMap$Amat)
  random.spacetime <- getDiag(fit1, field = "spacetime",
   year_label = years, year_range = c(1985, 2019), 
   Amat = DemoMap$Amat)
}

}
