## File Name: starts_summary_print_ic.R
## File Version: 0.12

starts_summary_print_ic <- function(object)
{
    cat( "AIC ", "=", round( object$ic$AIC, 0), starts_summary_print_pen(),
                round( object$ic$AIC - object$ic$deviance,2 ),
            "   | AIC=-2*LL + 2*p  \n" )
    cat( "AICc", "=", round( object$ic$AICc, 0), starts_summary_print_pen(),
                round( object$ic$AICc - object$ic$deviance,2 ) )
        cat("    | AICc=-2*LL + 2*p + 2*p*(p+1)/(n-p-1)  (bias corrected AIC)\n" )
    cat( "BIC ", "=", round( object$ic$BIC, 0), starts_summary_print_pen(),
                round( object$ic$BIC - object$ic$deviance,2 ),
            "   | BIC=-2*LL + log(n)*p  \n" )
    cat( "CAIC", "=", round( object$ic$CAIC, 0), starts_summary_print_pen(),
                round( object$ic$CAIC - object$ic$deviance,2 ) )
            cat("   | CAIC=-2*LL + [log(n)+1]*p  (consistent AIC)\n\n" )
}


starts_summary_print_pen <- function()
{
    res <- paste0(" | penalty ", "=", " ")
    return(res)
}
