% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findMotif.R
\name{findMotif}
\alias{findMotif}
\title{Returns an alignment data frame of alleles that share a specific amino acid motif}
\usage{
findMotif(motif, filename, alignments)
}
\arguments{
\item{motif}{An amino acid motif in the following format: Locus*##$~##$~##$, where ## identifies a peptide position, and $ identifies an amino acid residue. Motifs can include any number of amino acids.}

\item{filename}{The full file path of the user specified dataset if the user wishes to use their own file, or the pre-bundled Solberg dataset. User provided datasets must be a .dat, .txt, or.csv file, and must conform to the structure and format of the Solberg dataset.}

\item{alignments}{A list object of sub-lists of data frames of protein alignments for the HLA and HLA-region genes supported in the ANHIG/IMGTHLA GitHub Repository. Alignments will always be the most recent version IPD-IMGT/HLA Database version.}
}
\value{
An amino acid alignment dataframe of alleles that share the specified motif. Otherwise, a vector containing FALSE and an error message is returned.
}
\description{
Returns an alignment data frame of alleles that share a specific amino acid motif.
}
\note{
For internal SSHAARP use only.
}
