% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_contribution.R
\name{max_contribution}
\alias{max_contribution}
\alias{n_contributors}
\title{Find Major Contributions to Aggregates and Count Contributors}
\usage{
max_contribution(
  x,
  y,
  n = 1,
  id = NULL,
  output = "y",
  drop = TRUE,
  decreasing = TRUE,
  remove_fraction = NULL,
  do_abs = TRUE
)

n_contributors(x, y = rep(1L, nrow(x)), id = NULL, output = "n_contr", ...)
}
\arguments{
\item{x}{A (sparse) dummy matrix}

\item{y}{A numeric vector of input values (contributions).}

\item{n}{Integer. The number of largest contributors to identify for each aggregate.
Default is 1.}

\item{id}{An optional vector for grouping. When non-NULL, major contributions are
found after aggregation within each group specified by \code{id}.
Aggregates with missing \code{id} values are excluded.}

\item{output}{A character vector specifying the desired output. Possible values:
\itemize{
\item \code{"y"}: A matrix with the largest contributions in the first column, the second largest in the second column, and so on.
\item \code{"id"}: A matrix of IDs associated with the largest contributions. If an \code{id} vector is provided, it returns these IDs; otherwise, it returns indices.
\item \code{"n_contr"}: An integer vector indicating the number of contributors to each aggregate.
\item \code{"n_0_contr"}: An integer vector indicating the number of contributors that contribute a value of 0 to each aggregate.
\item \code{"n_non0_contr"}: An integer vector indicating the number of contributors that contribute a nonzero value to each aggregate.
\item \code{"sums"}: A numeric vector containing the aggregate sums of \code{y}.
\item \code{"n_contr_all"}, \code{"n_0_contr_all"}, \code{"n_non0_contr_all"}, \code{"sums_all"}:
Same as the corresponding outputs above, but without applying the \code{remove_fraction} parameter.
}}

\item{drop}{Logical. If TRUE (default) and \code{output} has length 1,
the function returns the single list element directly instead of a list containing one element.}

\item{decreasing}{Logical. If TRUE (default), finds the largest contributors.
If FALSE, finds the smallest contributors.}

\item{remove_fraction}{A numeric vector containing values in the interval \verb{[0, 1]}, specifying contributors to be removed when identifying the largest contributions.
\itemize{
\item If an \code{id} vector is provided, \code{remove_fraction} must be named according to the IDs of the contributors to be removed.
\item If no \code{id} vector is provided, the length of \code{remove_fraction} must match the length of \code{y}. In this case, contributors not to be removed should have a value of \code{NA} in \code{remove_fraction}.
\item The actual values in \code{remove_fraction} are used for calculating \code{"sums"} (see description above).
}}

\item{do_abs}{Logical. If TRUE (default), uses the absolute values of the summed contributions.
The summation is performed for all contributions from the same contributor,
within each aggregate being computed.}

\item{...}{Further arguments to \code{max_contribution}  (used by \code{n_contributors}).}
}
\value{
A list or a single element, depending on the values of the \code{output} and \code{drop} parameters.
}
\description{
These functions analyze contributions to aggregates, assuming that the aggregates are calculated
using a dummy matrix with the formula: \code{z = t(x) \%*\% y}.
}
\details{
The \code{max_contribution} function identifies the largest contributions to these aggregates, while
the wrapper function \code{n_contributors} is designed specifically to count the number of contributors
for each aggregate.
}
\examples{

z <- SSBtoolsData("magnitude1")
a <- ModelMatrix(z, formula = ~sector4 + geo, crossTable = TRUE)

cbind(a$crossTable, 
      y =  max_contribution(x = a$modelMatrix, y = z$value, n = 2), 
      id = max_contribution(x = a$modelMatrix, y = z$value, n = 2, output = "id"),
      n =  n_contributors(  x = a$modelMatrix, y = z$value, n = 2))

cbind(a$crossTable, 
      y = max_contribution(x = a$modelMatrix, y = z$value, n = 3, id = z$company), 
      id = max_contribution(a$modelMatrix, z$value, 3, id = z$company, output = "id"))

max_contribution(x = a$modelMatrix, 
                 y = z$value, 
                 n = 3, 
                 id = z$company, 
                 output = c("y", "id", "n_contr", "sums"))

as.data.frame(
  max_contribution(x = a$modelMatrix, 
                   y = z$value, 
                   n = 3, 
                   id = z$company, 
                   output = c("y", "id", "n_contr", "sums", "n_contr_all", "sums_all"), 
                   remove_fraction = c(B = 1)))

}
