% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildRSM.R
\name{buildRSM}
\alias{buildRSM}
\title{Build Response Surface Model}
\usage{
buildRSM(x, y, control = list())
}
\arguments{
\item{x}{design matrix (sample locations), rows for each sample, columns for each variable.}

\item{y}{vector of observations at \code{x}}

\item{control}{(list), with the options for the model building procedure:
\describe{
    \item{\code{mainEffectsOnly}}{Logical, defaults to FALSE. Set to TRUE if a model with main effects only is desired (no interactions, second order effects).}
    \item{\code{canonical}}{Logical, defaults to FALSE. If this is TRUE, use the canonical path to descent from saddle points. Else, simply use steepest descent}
}}
}
\value{
returns an object of class \code{spotRSM}.
}
\description{
Using the \code{rsm} package, this function builds a linear response surface model.
}
\examples{
## Create a test function: branin
braninFunction <- function (x) {	
	(x[2]  - 5.1/(4 * pi^2) * (x[1] ^2) + 5/pi * x[1]  - 6)^2 + 
10 * (1 - 1/(8 * pi)) * cos(x[1] ) + 10
}
## Create design points
x <- cbind(runif(20)*15-5,runif(20)*15)
## Compute observations at design points
y <- as.matrix(apply(x,1,braninFunction))
## Create model with default settings
fit <- buildRSM(x,y)
## Predict new point
predict(fit,cbind(1,2))
## True value at location
braninFunction(c(1,2))
## plots
plot(fit)
## path of steepest descent
descentSpotRSM(fit)

}
\seealso{
\code{\link{predict.spotRSM}}
}
