% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyclone.R
\name{calculationBarthMuschelknautz}
\alias{calculationBarthMuschelknautz}
\title{Cyclone Simulation: Barth/Muschelknautz}
\usage{
calculationBarthMuschelknautz(cyclone, fluid)
}
\arguments{
\item{cyclone}{list of cyclone's geometrical parameters}

\item{fluid}{list of fluid parameters}
}
\value{
returns a function that calculates the fractional efficiency for the specified diameter, see example.
}
\description{
Calculate cyclone collection efficiency according to Barth/Muschelknautz.
}
\examples{
## get function for specified cyclone and fluid type
fun <- calculationBarthMuschelknautz(
       cyclone=list(Da=1260,H=2500,Dt=420,Ht=640,Epsilon=13.1340,He=600,Be=200),
       fluid=list(Mu=18.5*10^(-6),Vp=5000,Rhop=2000,Rhof=1.204,Croh=50))[[1]]
## specify diameters to be calculated
x<-seq(from=0,to=35,by=0.01)*1e-6 
## compute fractional efficiency and plot
plot(x,fun(x),type="l",xlab=expression(paste("Particle Size [", mu, "m]")),
     ylab="Fractional Efficiency")

}
\keyword{internal}
