% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPARRAfairness_functions.R
\name{demographic_parity}
\alias{demographic_parity}
\title{demographic_parity}
\usage{
demographic_parity(
  scores,
  group1,
  group2,
  cutoffs = seq(min(scores, na.rm = TRUE), max(scores, na.rm = TRUE), length = 100)
)
}
\arguments{
\item{scores}{vector of risk scores}

\item{group1}{indices of group 1}

\item{group2}{indices of group 2}

\item{cutoffs}{score cutoffs at which to estimate DP (default 100 evenly-spaced)}
}
\value{
matrix of dimension length(cutoffs)x4, with (i,2g-1)th entry the proportion of scores in group g which are less than or equal to the ith cutoff value and (i,2g)th entry the approximate standard error of the (i,2g-1)th entry
}
\description{
Estimates demographic parity for a risk score (essentially cumulative distribution function)
}
\examples{
# See vignette
}
