% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_redlist_china.R
\name{get_redlist_china}
\alias{get_redlist_china}
\title{Query Redlist of Chinese Biodiversity}
\format{
assessment status:
\describe{
\item{EX}{Extinct}
\item{EW}{Extinct in the wild}
\item{RE}{Regional Extinct}
\item{CR}{Critically Endangered}
\item{EN}{Endangered}
\item{VU}{Vulnerable}
\item{NT}{Near Threatened}
\item{LC}{Least Concern}
\item{DD}{Data Deficient}
}
}
\usage{
get_redlist_china(
  query = NULL,
  option = "Scientific Names",
  group = "Amphibians",
  viewDT = FALSE
)
}
\arguments{
\item{query}{\code{string} The string to query for.}

\item{option}{\code{character} There is one required parameter, which is either Chinese Names or Scientific Names. Give eithera Chinese Names or Scientific Names. If an Scientific Names is given, the Chinese Names parameter may not be used. Only exact matches found the name given will be returned. option=c("Chinese Names","Scientific Names"),,the default value is "Scientific Names".}

\item{group}{\code{character} There is one required parameter, group=c("Amphibians","Birds","Inland Fishes","Mammals","Reptiles","Plants","Fungi").}

\item{viewDT}{\code{logic} TRUE or FALSE,the default value is FALSE.}
}
\value{
object
}
\description{
Query Redlist of China’s Biodiversity of Vertebrate, Higher Plants and Macrofungi.
}
\details{
Visit the website \url{http://www.mee.gov.cn} for more details.
}
\examples{
\donttest{
#query assessment status via Chinese Names or Scientific Names
get_redlist_china(query = "Anguilla", option = "Scientific Names")
get_redlist_china(query = "Anguilla nebulosa", option = "Scientific Names")

#creates an HTML widget to display rectangular data
get_redlist_china(group = "Inland Fishes", viewDT = TRUE)
}
}
\references{
\url{http://www.mee.gov.cn}

\url{http://www.mee.gov.cn/xxgk2018/xxgk/xxgk01/201805/t20180524_629586.html}

\url{http://www.mee.gov.cn/gkml/hbb/bgg/201309/t20130912_260061.html}

\url{http://www.mee.gov.cn/gkml/hbb/bgg/201505/t20150525_302233.html}
}
\author{
Liuyong Ding \email{ly_ding@126.com}

Ke Yang \email{ydyangke@163.com}
}
