% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_synonyms.R
\name{find_synonyms}
\alias{find_synonyms}
\title{Find synonyms via species name}
\usage{
find_synonyms(query, mc.cores = 2)
}
\arguments{
\item{query}{\code{character} species name,The function is similar to [get_col_global()].}

\item{mc.cores}{The number of cores to use, i.e. at most how many child processes will be run simultaneously. The option is initialized from environment variable MC_CORES if set. Must be at least one, and parallelization requires at least two cores,see [mclapply()] for details.}
}
\value{
object
}
\description{
Find synonyms via species name from Catalogue of Life Global.
}
\details{
Visit the website \url{http://webservice.catalogueoflife.org/col/webservice} for more details.
}
\examples{
\donttest{
##Get Catalogue of Life Global checklist via species name
x <- get_col_global(query = c("Anguilla marmorata","Anguilla japonica",
                              "Anguilla bicolor","Anguilla nebulosa",
                              "Anguilla luzonensis"),
                               option = "name")
str(x)

##Find synonyms via species name
find_synonyms(query = c("Anguilla marmorata","Anguilla japonica",
                        "Anguilla bicolor","Anguilla nebulosa",
                        "Anguilla luzonensis"))
}
}
\author{
Liuyong Ding
}
